/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.tools.consumer.DefaultMessageFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingMessageFormatter
implements MessageFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingMessageFormatter.class);
    private final DefaultMessageFormatter defaultWriter = new DefaultMessageFormatter();

    LoggingMessageFormatter() {
    }

    public void configure(Map<String, ?> configs) {
        this.defaultWriter.configure(configs);
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        this.defaultWriter.writeTo(consumerRecord, output);
        String timestamp = consumerRecord.timestampType() != TimestampType.NO_TIMESTAMP_TYPE ? String.valueOf(consumerRecord.timestampType()) + ":" + consumerRecord.timestamp() + ", " : "";
        String key = "key:" + (String)(consumerRecord.key() == null ? "null " : new String((byte[])consumerRecord.key(), StandardCharsets.UTF_8) + ", ");
        String value = "value:" + (consumerRecord.value() == null ? "null" : new String((byte[])consumerRecord.value(), StandardCharsets.UTF_8));
        LOG.info(timestamp + key + value);
    }
}

