/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.spi;

import jakarta.persistence.AttributeConverter;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.AssertionFailure;
import org.hibernate.Internal;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.internal.RootMappingDefaults;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.process.internal.ManagedResourcesImpl;
import org.hibernate.boot.model.process.internal.ScanningCoordinator;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.NoOpMetadataSourceProcessorImpl;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.source.internal.annotations.AnnotationMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.annotations.DomainModelSource;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchyBuilder;
import org.hibernate.boot.model.source.internal.hbm.EntityHierarchySourceImpl;
import org.hibernate.boot.model.source.internal.hbm.HbmMetadataSourceProcessorImpl;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.internal.hbm.ModelBinder;
import org.hibernate.boot.model.source.spi.MetadataSourceProcessor;
import org.hibernate.boot.models.internal.DomainModelCategorizationCollector;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.models.xml.spi.XmlPreProcessingResult;
import org.hibernate.boot.models.xml.spi.XmlPreProcessor;
import org.hibernate.boot.models.xml.spi.XmlProcessingResult;
import org.hibernate.boot.models.xml.spi.XmlProcessor;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.AdditionalMappingContributions;
import org.hibernate.boot.spi.AdditionalMappingContributor;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MappingDefaults;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.TimeZoneStorageStrategy;
import org.hibernate.type.WrapperArrayHandling;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.CharacterArrayJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.JsonArrayJdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.JsonAsStringArrayJdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.JsonAsStringJdbcType;
import org.hibernate.type.descriptor.jdbc.UuidAsBinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlArrayJdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.XmlAsStringArrayJdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.XmlAsStringJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.NamedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.CompositeUserType;

public class MetadataBuildingProcess {
    public static MetadataImplementor build(MetadataSources sources, BootstrapContext bootstrapContext, MetadataBuildingOptions options) {
        return MetadataBuildingProcess.complete(MetadataBuildingProcess.prepare(sources, bootstrapContext), bootstrapContext, options);
    }

    public static ManagedResources prepare(MetadataSources sources, BootstrapContext bootstrapContext) {
        ManagedResourcesImpl managedResources = ManagedResourcesImpl.baseline(sources, bootstrapContext);
        boolean xmlMappingEnabled = bootstrapContext.getConfigurationService().getSetting("hibernate.xml_mapping_enabled", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        ScanningCoordinator.INSTANCE.coordinateScan(managedResources, bootstrapContext, xmlMappingEnabled ? sources.getXmlMappingBinderAccess() : null);
        return managedResources;
    }

    public static MetadataImplementor complete(ManagedResources managedResources, BootstrapContext bootstrapContext, MetadataBuildingOptions options) {
        InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl(bootstrapContext, options);
        MetadataBuildingProcess.handleTypes(bootstrapContext, options, metadataCollector);
        DomainModelSource domainModelSource = MetadataBuildingProcess.processManagedResources(managedResources, metadataCollector, bootstrapContext, options.getMappingDefaults());
        MetadataBuildingContextRootImpl rootMetadataBuildingContext = new MetadataBuildingContextRootImpl("orm", bootstrapContext, options, metadataCollector, domainModelSource.getEffectiveMappingDefaults());
        managedResources.getAttributeConverterDescriptors().forEach(metadataCollector::addAttributeConverter);
        bootstrapContext.getTypeConfiguration().scope(rootMetadataBuildingContext);
        MetadataBuildingProcess.coordinateProcessors(managedResources, options, rootMetadataBuildingContext, domainModelSource, metadataCollector);
        ClassLoaderService classLoaderService = bootstrapContext.getClassLoaderService();
        MetadataBuildingProcess.processAdditionalMappingContributions(metadataCollector, options, classLoaderService, rootMetadataBuildingContext);
        MetadataBuildingProcess.applyExtraQueryImports(managedResources, metadataCollector);
        return metadataCollector.buildMetadataInstance(rootMetadataBuildingContext);
    }

    @Internal
    public static void coordinateProcessors(final ManagedResources managedResources, final MetadataBuildingOptions options, final MetadataBuildingContextRootImpl rootMetadataBuildingContext, final DomainModelSource domainModelSource, InFlightMetadataCollectorImpl metadataCollector) {
        MetadataSourceProcessor processor = new MetadataSourceProcessor(){
            private final MetadataSourceProcessor hbmProcessor;
            private final AnnotationMetadataSourceProcessorImpl annotationProcessor;
            {
                this.hbmProcessor = options.isXmlMappingEnabled() ? new HbmMetadataSourceProcessorImpl(managedResources, (MetadataBuildingContext)rootMetadataBuildingContext) : new NoOpMetadataSourceProcessorImpl();
                this.annotationProcessor = new AnnotationMetadataSourceProcessorImpl(managedResources, domainModelSource, rootMetadataBuildingContext);
            }

            @Override
            public void prepare() {
                this.hbmProcessor.prepare();
                this.annotationProcessor.prepare();
            }

            @Override
            public void processTypeDefinitions() {
                this.hbmProcessor.processTypeDefinitions();
                this.annotationProcessor.processTypeDefinitions();
            }

            @Override
            public void processQueryRenames() {
                this.hbmProcessor.processQueryRenames();
                this.annotationProcessor.processQueryRenames();
            }

            @Override
            public void processNamedQueries() {
                this.hbmProcessor.processNamedQueries();
                this.annotationProcessor.processNamedQueries();
            }

            @Override
            public void processAuxiliaryDatabaseObjectDefinitions() {
                this.hbmProcessor.processAuxiliaryDatabaseObjectDefinitions();
                this.annotationProcessor.processAuxiliaryDatabaseObjectDefinitions();
            }

            @Override
            public void processIdentifierGenerators() {
                this.hbmProcessor.processIdentifierGenerators();
                this.annotationProcessor.processIdentifierGenerators();
            }

            @Override
            public void processFilterDefinitions() {
                this.hbmProcessor.processFilterDefinitions();
                this.annotationProcessor.processFilterDefinitions();
            }

            @Override
            public void processFetchProfiles() {
                this.hbmProcessor.processFetchProfiles();
                this.annotationProcessor.processFetchProfiles();
            }

            @Override
            public void prepareForEntityHierarchyProcessing() {
                this.hbmProcessor.prepareForEntityHierarchyProcessing();
                this.annotationProcessor.prepareForEntityHierarchyProcessing();
            }

            @Override
            public void processEntityHierarchies(Set<String> processedEntityNames) {
                this.hbmProcessor.processEntityHierarchies(processedEntityNames);
                this.annotationProcessor.processEntityHierarchies(processedEntityNames);
            }

            @Override
            public void postProcessEntityHierarchies() {
                this.hbmProcessor.postProcessEntityHierarchies();
                this.annotationProcessor.postProcessEntityHierarchies();
            }

            @Override
            public void processResultSetMappings() {
                this.hbmProcessor.processResultSetMappings();
                this.annotationProcessor.processResultSetMappings();
            }

            @Override
            public void finishUp() {
                this.hbmProcessor.finishUp();
                this.annotationProcessor.finishUp();
            }
        };
        processor.prepare();
        processor.processTypeDefinitions();
        processor.processQueryRenames();
        processor.processAuxiliaryDatabaseObjectDefinitions();
        processor.processIdentifierGenerators();
        processor.processFilterDefinitions();
        processor.processFetchProfiles();
        HashSet<String> processedEntityNames = new HashSet<String>();
        processor.prepareForEntityHierarchyProcessing();
        processor.processEntityHierarchies(processedEntityNames);
        processor.postProcessEntityHierarchies();
        processor.processResultSetMappings();
        metadataCollector.processSecondPasses(rootMetadataBuildingContext);
        processor.processNamedQueries();
        processor.finishUp();
    }

    @Internal
    public static DomainModelSource processManagedResources(ManagedResources managedResources, InFlightMetadataCollector metadataCollector, BootstrapContext bootstrapContext, MappingDefaults optionDefaults) {
        PersistenceUnitMetadata aggregatedPersistenceUnitMetadata = metadataCollector.getPersistenceUnitMetadata();
        ModelsContext modelsContext = bootstrapContext.getModelsContext();
        XmlPreProcessingResult xmlPreProcessingResult = XmlPreProcessor.preProcessXmlResources(managedResources, aggregatedPersistenceUnitMetadata);
        List allKnownClassNames = CollectionHelper.mutableJoin((Collection)managedResources.getAnnotatedClassReferences().stream().map(Class::getName).collect(Collectors.toList()), managedResources.getAnnotatedClassNames(), xmlPreProcessingResult.getMappedClasses());
        managedResources.getAnnotatedPackageNames().forEach(packageName -> {
            try {
                Class packageInfoClass = modelsContext.getClassLoading().classForName(packageName + ".package-info");
                allKnownClassNames.add(packageInfoClass.getName());
            }
            catch (ClassLoadingException classLoadingException) {
                // empty catch block
            }
        });
        managedResources.getAnnotatedClassReferences().forEach(clazz -> allKnownClassNames.add(clazz.getName()));
        ClassDetailsRegistry classDetailsRegistry = modelsContext.getClassDetailsRegistry();
        DomainModelCategorizationCollector modelCategorizationCollector = new DomainModelCategorizationCollector(metadataCollector.getGlobalRegistrations(), modelsContext);
        RootMappingDefaults rootMappingDefaults = new RootMappingDefaults(optionDefaults, aggregatedPersistenceUnitMetadata);
        XmlProcessingResult xmlProcessingResult = XmlProcessor.processXml(xmlPreProcessingResult, aggregatedPersistenceUnitMetadata, modelCategorizationCollector::apply, modelsContext, bootstrapContext, rootMappingDefaults);
        HashSet categorizedClassNames = new HashSet();
        allKnownClassNames.forEach(className -> {
            if (categorizedClassNames.add(className)) {
                ClassDetails classDetails = classDetailsRegistry.resolveClassDetails(className);
                MetadataBuildingProcess.applyKnownClass(classDetails, (HashSet<String>)categorizedClassNames, classDetailsRegistry, modelCategorizationCollector);
            }
        });
        xmlPreProcessingResult.getMappedNames().forEach(mappedName -> {
            if (categorizedClassNames.add(mappedName)) {
                ClassDetails classDetails = classDetailsRegistry.resolveClassDetails(mappedName);
                MetadataBuildingProcess.applyKnownClass(classDetails, (HashSet<String>)categorizedClassNames, classDetailsRegistry, modelCategorizationCollector);
            }
        });
        xmlProcessingResult.apply();
        return new DomainModelSource(classDetailsRegistry, CollectionHelper.mutableJoin(allKnownClassNames, xmlPreProcessingResult.getMappedNames()), modelCategorizationCollector.getGlobalRegistrations(), rootMappingDefaults, aggregatedPersistenceUnitMetadata);
    }

    private static void applyKnownClass(String className, HashSet<String> categorizedClassNames, ClassDetailsRegistry classDetailsRegistry, DomainModelCategorizationCollector modelCategorizationCollector) {
        if (categorizedClassNames.add(className)) {
            ClassDetails classDetails = classDetailsRegistry.resolveClassDetails(className);
            MetadataBuildingProcess.applyKnownClass(classDetails, categorizedClassNames, classDetailsRegistry, modelCategorizationCollector);
        }
    }

    private static void applyKnownClass(ClassDetails classDetails, HashSet<String> categorizedClassNames, ClassDetailsRegistry classDetailsRegistry, DomainModelCategorizationCollector modelCategorizationCollector) {
        modelCategorizationCollector.apply(classDetails);
        if (classDetails.getSuperClass() != null && classDetails.getSuperClass() != ClassDetails.OBJECT_CLASS_DETAILS && categorizedClassNames.add(classDetails.getSuperClass().getClassName())) {
            MetadataBuildingProcess.applyKnownClass(classDetails.getSuperClass(), categorizedClassNames, classDetailsRegistry, modelCategorizationCollector);
        }
    }

    private static void processAdditionalMappingContributions(InFlightMetadataCollectorImpl metadataCollector, MetadataBuildingOptions options, ClassLoaderService classLoaderService, MetadataBuildingContextRootImpl rootMetadataBuildingContext) {
        AdditionalMappingContributionsImpl contributions = new AdditionalMappingContributionsImpl(metadataCollector, options, options.isXmlMappingEnabled() ? new MappingBinder((ResourceStreamLocator)classLoaderService, () -> false) : null, rootMetadataBuildingContext);
        Collection<AdditionalMappingContributor> additionalMappingContributors = classLoaderService.loadJavaServices(AdditionalMappingContributor.class);
        additionalMappingContributors.forEach(contributor -> {
            contributions.setCurrentContributor(contributor.getContributorName());
            try {
                contributor.contribute(contributions, metadataCollector, classLoaderService, rootMetadataBuildingContext);
            }
            finally {
                contributions.setCurrentContributor(null);
            }
        });
        contributions.complete();
    }

    private static void applyExtraQueryImports(ManagedResources managedResources, InFlightMetadataCollectorImpl metadataCollector) {
        Map<String, Class<?>> extraQueryImports = managedResources.getExtraQueryImports();
        if (extraQueryImports == null || extraQueryImports.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Class<?>> entry : extraQueryImports.entrySet()) {
            metadataCollector.addImport(entry.getKey(), entry.getValue().getName());
        }
    }

    private static void handleTypes(BootstrapContext bootstrapContext, final MetadataBuildingOptions options, final InFlightMetadataCollector metadataCollector) {
        int preferredSqlTypeCodeForInstant;
        JdbcType timeWithTimeZoneOverride;
        int preferredSqlTypeCodeForDuration;
        JdbcTypeConstructor constructor;
        ClassLoaderService classLoaderService = bootstrapContext.getClassLoaderService();
        final TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        StandardServiceRegistry serviceRegistry = bootstrapContext.getServiceRegistry();
        JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
        TypeContributions typeContributions = new TypeContributions(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public void contributeAttributeConverter(Class<? extends AttributeConverter<?, ?>> converterClass) {
                metadataCollector.getConverterRegistry().addAttributeConverter(converterClass);
            }

            @Override
            public void contributeType(CompositeUserType<?> type) {
                options.getCompositeUserTypes().add(type);
            }
        };
        if (options.getWrapperArrayHandling() == WrapperArrayHandling.LEGACY) {
            typeConfiguration.getJavaTypeRegistry().addDescriptor(ByteArrayJavaType.INSTANCE);
            typeConfiguration.getJavaTypeRegistry().addDescriptor(CharacterArrayJavaType.INSTANCE);
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            basicTypeRegistry.addTypeReferenceRegistrationKey(StandardBasicTypes.CHARACTER_ARRAY.getName(), Character[].class.getName(), "Character[]");
            basicTypeRegistry.addTypeReferenceRegistrationKey(StandardBasicTypes.BINARY_WRAPPER.getName(), Byte[].class.getName(), "Byte[]");
        }
        Dialect dialect = options.getServiceRegistry().requireService(JdbcServices.class).getDialect();
        dialect.contribute(typeContributions, options.getServiceRegistry());
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, options.getServiceRegistry());
        }
        int preferredSqlTypeCodeForUuid = ConfigurationHelper.getPreferredSqlTypeCodeForUuid(serviceRegistry);
        if (preferredSqlTypeCodeForUuid != 3000) {
            MetadataBuildingProcess.adaptToPreferredSqlTypeCode(typeConfiguration, jdbcTypeRegistry, preferredSqlTypeCodeForUuid, UUID.class, StandardBasicTypes.UUID.getName(), "org.hibernate.type.PostgresUUIDType", "uuid", "pg-uuid");
        } else {
            jdbcTypeRegistry.addDescriptorIfAbsent(UuidAsBinaryJdbcType.INSTANCE);
        }
        jdbcTypeRegistry.addDescriptorIfAbsent(JsonAsStringJdbcType.VARCHAR_INSTANCE);
        jdbcTypeRegistry.addDescriptorIfAbsent(XmlAsStringJdbcType.VARCHAR_INSTANCE);
        if (jdbcTypeRegistry.getConstructor(3018) == null) {
            if (jdbcTypeRegistry.getDescriptor(3001).getDdlTypeCode() == 3001) {
                jdbcTypeRegistry.addTypeConstructor(JsonArrayJdbcTypeConstructor.INSTANCE);
            } else {
                jdbcTypeRegistry.addTypeConstructor(JsonAsStringArrayJdbcTypeConstructor.INSTANCE);
            }
        }
        if (jdbcTypeRegistry.getConstructor(3019) == null) {
            if (jdbcTypeRegistry.getDescriptor(2009).getDdlTypeCode() == 2009) {
                jdbcTypeRegistry.addTypeConstructor(XmlArrayJdbcTypeConstructor.INSTANCE);
            } else {
                jdbcTypeRegistry.addTypeConstructor(XmlAsStringArrayJdbcTypeConstructor.INSTANCE);
            }
        }
        if (jdbcTypeRegistry.getConstructor(2003) == null && (constructor = jdbcTypeRegistry.getConstructor(ConfigurationHelper.getPreferredSqlTypeCodeForArray(serviceRegistry))) != null) {
            jdbcTypeRegistry.addTypeConstructor(2003, constructor);
        }
        if ((preferredSqlTypeCodeForDuration = ConfigurationHelper.getPreferredSqlTypeCodeForDuration(serviceRegistry)) != 3100) {
            MetadataBuildingProcess.adaptToPreferredSqlTypeCode(typeConfiguration, jdbcTypeRegistry, preferredSqlTypeCodeForDuration, Duration.class, StandardBasicTypes.DURATION.getName(), "org.hibernate.type.DurationType");
        } else {
            MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3100, 3015);
        }
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3002, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3200, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3201, -3);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3250, 3200);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3004, 2004);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3005, 2005);
        MetadataBuildingProcess.addFallbackIfNecessary(jdbcTypeRegistry, 3006, 2011);
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType geometryType = ddlTypeRegistry.getDescriptor(3200);
        if (geometryType != null) {
            ddlTypeRegistry.addDescriptorIfAbsent(new DdlTypeImpl(3250, geometryType.getTypeName((Long)null, (Integer)null, (Integer)null), dialect));
        }
        typeConfiguration.addBasicTypeRegistrationContributions(options.getBasicTypeRegistrations());
        for (CompositeUserType<?> compositeUserType : options.getCompositeUserTypes()) {
            metadataCollector.registerCompositeUserType(compositeUserType.returnedClass(), ReflectHelper.getClass(compositeUserType.getClass()));
        }
        JdbcType timestampWithTimeZoneOverride = MetadataBuildingProcess.getTimestampWithTimeZoneOverride(options, jdbcTypeRegistry);
        if (timestampWithTimeZoneOverride != null) {
            MetadataBuildingProcess.adaptTimestampTypesToDefaultTimeZoneStorage(typeConfiguration, timestampWithTimeZoneOverride);
        }
        if ((timeWithTimeZoneOverride = MetadataBuildingProcess.getTimeWithTimeZoneOverride(options, jdbcTypeRegistry)) != null) {
            MetadataBuildingProcess.adaptTimeTypesToDefaultTimeZoneStorage(typeConfiguration, timeWithTimeZoneOverride);
        }
        if ((preferredSqlTypeCodeForInstant = ConfigurationHelper.getPreferredSqlTypeCodeForInstant(serviceRegistry)) != 3003) {
            MetadataBuildingProcess.adaptToPreferredSqlTypeCode(typeConfiguration, jdbcTypeRegistry, preferredSqlTypeCodeForInstant, Instant.class, StandardBasicTypes.INSTANT.getName(), "org.hibernate.type.InstantType", "instant");
        }
    }

    private static void adaptToPreferredSqlTypeCode(JdbcTypeRegistry jdbcTypeRegistry, JdbcType dialectUuidDescriptor, int defaultSqlTypeCode, int preferredSqlTypeCode) {
        if (jdbcTypeRegistry.findDescriptor(defaultSqlTypeCode) == dialectUuidDescriptor) {
            jdbcTypeRegistry.addDescriptor(defaultSqlTypeCode, jdbcTypeRegistry.getDescriptor(preferredSqlTypeCode));
        }
    }

    private static void adaptToPreferredSqlTypeCode(TypeConfiguration typeConfiguration, JdbcTypeRegistry jdbcTypeRegistry, int preferredSqlTypeCode, Class<?> javaType, String name, String ... additionalKeys) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        NamedBasicTypeImpl basicType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor(javaType), jdbcTypeRegistry.getDescriptor(preferredSqlTypeCode), name);
        String[] keys = Arrays.copyOf(additionalKeys, additionalKeys.length + 2);
        keys[additionalKeys.length] = javaType.getSimpleName();
        keys[additionalKeys.length + 1] = javaType.getName();
        basicTypeRegistry.register(basicType, keys);
    }

    private static void adaptTimeTypesToDefaultTimeZoneStorage(TypeConfiguration typeConfiguration, JdbcType timestampWithTimeZoneOverride) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        NamedBasicTypeImpl offsetDateTimeType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)OffsetTime.class)), timestampWithTimeZoneOverride, "OffsetTime");
        basicTypeRegistry.register(offsetDateTimeType, "org.hibernate.type.OffsetTimeType", OffsetTime.class.getSimpleName(), OffsetTime.class.getName());
    }

    private static void adaptTimestampTypesToDefaultTimeZoneStorage(TypeConfiguration typeConfiguration, JdbcType timestampWithTimeZoneOverride) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        NamedBasicTypeImpl offsetDateTimeType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)OffsetDateTime.class)), timestampWithTimeZoneOverride, "OffsetDateTime");
        NamedBasicTypeImpl zonedDateTimeType = new NamedBasicTypeImpl(javaTypeRegistry.getDescriptor((Type)((Object)ZonedDateTime.class)), timestampWithTimeZoneOverride, "ZonedDateTime");
        basicTypeRegistry.register(offsetDateTimeType, "org.hibernate.type.OffsetDateTimeType", OffsetDateTime.class.getSimpleName(), OffsetDateTime.class.getName());
        basicTypeRegistry.register(zonedDateTimeType, "org.hibernate.type.ZonedDateTimeType", ZonedDateTime.class.getSimpleName(), ZonedDateTime.class.getName());
    }

    private static JdbcType getTimeWithTimeZoneOverride(MetadataBuildingOptions options, JdbcTypeRegistry jdbcTypeRegistry) {
        return switch (options.getDefaultTimeZoneStorage()) {
            case TimeZoneStorageStrategy.NORMALIZE -> jdbcTypeRegistry.getDescriptor(92);
            case TimeZoneStorageStrategy.NORMALIZE_UTC -> jdbcTypeRegistry.getDescriptor(3007);
            default -> null;
        };
    }

    private static JdbcType getTimestampWithTimeZoneOverride(MetadataBuildingOptions options, JdbcTypeRegistry jdbcTypeRegistry) {
        return switch (options.getDefaultTimeZoneStorage()) {
            case TimeZoneStorageStrategy.NORMALIZE -> jdbcTypeRegistry.getDescriptor(93);
            case TimeZoneStorageStrategy.NORMALIZE_UTC -> jdbcTypeRegistry.getDescriptor(3003);
            default -> null;
        };
    }

    private static void addFallbackIfNecessary(JdbcTypeRegistry jdbcTypeRegistry, int typeCode, int fallbackTypeCode) {
        if (!jdbcTypeRegistry.hasRegisteredDescriptor(typeCode)) {
            jdbcTypeRegistry.addDescriptor(typeCode, jdbcTypeRegistry.getDescriptor(fallbackTypeCode));
        }
    }

    private static class AdditionalMappingContributionsImpl
    implements AdditionalMappingContributions {
        private final InFlightMetadataCollectorImpl metadataCollector;
        private final MetadataBuildingOptions options;
        private final MappingBinder mappingBinder;
        private final MetadataBuildingContextRootImpl rootMetadataBuildingContext;
        private final EntityHierarchyBuilder hierarchyBuilder = new EntityHierarchyBuilder();
        private List<Class<?>> additionalEntityClasses;
        private List<ClassDetails> additionalClassDetails;
        private List<JaxbEntityMappingsImpl> additionalJaxbMappings;
        private boolean extraHbmXml = false;
        private String currentContributor;

        public AdditionalMappingContributionsImpl(InFlightMetadataCollectorImpl metadataCollector, MetadataBuildingOptions options, MappingBinder mappingBinder, MetadataBuildingContextRootImpl rootMetadataBuildingContext) {
            this.metadataCollector = metadataCollector;
            this.options = options;
            this.mappingBinder = mappingBinder;
            this.rootMetadataBuildingContext = rootMetadataBuildingContext;
        }

        public void setCurrentContributor(String contributor) {
            this.currentContributor = contributor == null ? "orm" : contributor;
        }

        @Override
        public void contributeEntity(Class<?> entityType) {
            if (this.additionalEntityClasses == null) {
                this.additionalEntityClasses = new ArrayList();
            }
            this.additionalEntityClasses.add(entityType);
        }

        @Override
        public void contributeManagedClass(ClassDetails classDetails) {
            if (this.additionalClassDetails == null) {
                this.additionalClassDetails = new ArrayList<ClassDetails>();
            }
            this.additionalClassDetails.add(classDetails);
            ((MutableClassDetailsRegistry)this.rootMetadataBuildingContext.getBootstrapContext().getModelsContext().getClassDetailsRegistry().as(MutableClassDetailsRegistry.class)).addClassDetails(classDetails.getName(), classDetails);
        }

        @Override
        public void contributeBinding(InputStream xmlStream) {
            Origin origin = new Origin(SourceType.INPUT_STREAM, null);
            Binding binding = this.mappingBinder.bind(xmlStream, origin);
            JaxbBindableMappingDescriptor bindingRoot = (JaxbBindableMappingDescriptor)binding.getRoot();
            if (bindingRoot instanceof JaxbHbmHibernateMapping) {
                JaxbHbmHibernateMapping hibernateMapping = (JaxbHbmHibernateMapping)bindingRoot;
                this.contributeBinding(hibernateMapping);
            } else if (bindingRoot instanceof JaxbEntityMappingsImpl) {
                JaxbEntityMappingsImpl entityMappings = (JaxbEntityMappingsImpl)bindingRoot;
                this.contributeBinding(entityMappings);
            } else {
                throw new AssertionFailure("Unexpected binding type");
            }
        }

        @Override
        public void contributeBinding(JaxbEntityMappingsImpl mappingJaxbBinding) {
            if (!this.options.isXmlMappingEnabled()) {
                return;
            }
            if (this.additionalJaxbMappings == null) {
                this.additionalJaxbMappings = new ArrayList<JaxbEntityMappingsImpl>();
            }
            this.additionalJaxbMappings.add(mappingJaxbBinding);
        }

        @Override
        public void contributeBinding(JaxbHbmHibernateMapping hbmJaxbBinding) {
            if (!this.options.isXmlMappingEnabled()) {
                return;
            }
            this.extraHbmXml = true;
            this.hierarchyBuilder.indexMappingDocument(new MappingDocument(this.currentContributor, hbmJaxbBinding, new Origin(SourceType.OTHER, null), this.rootMetadataBuildingContext));
        }

        @Override
        public void contributeTable(Table table) {
            Namespace namespace = this.metadataCollector.getDatabase().locateNamespace(table.getCatalogIdentifier(), table.getSchemaIdentifier());
            namespace.registerTable(table.getNameIdentifier(), table);
            this.metadataCollector.addTableNameBinding(table.getNameIdentifier(), table);
        }

        @Override
        public void contributeSequence(Sequence sequence) {
            Namespace namespace = this.metadataCollector.getDatabase().locateNamespace(sequence.getName().getCatalogName(), sequence.getName().getSchemaName());
            namespace.registerSequence(sequence.getName().getSequenceName(), sequence);
        }

        @Override
        public void contributeAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
            this.metadataCollector.addAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
        }

        @Override
        public EffectiveMappingDefaults getEffectiveMappingDefaults() {
            return this.rootMetadataBuildingContext.getEffectiveDefaults();
        }

        public void complete() {
            if (this.additionalEntityClasses != null || this.additionalClassDetails != null || this.additionalJaxbMappings != null) {
                AnnotationMetadataSourceProcessorImpl.processAdditionalMappings(this.additionalEntityClasses, this.additionalClassDetails, this.additionalJaxbMappings, this.rootMetadataBuildingContext, this.options);
            }
            if (this.extraHbmXml) {
                ModelBinder binder = ModelBinder.prepare(this.rootMetadataBuildingContext);
                for (EntityHierarchySourceImpl entityHierarchySource : this.hierarchyBuilder.buildHierarchies()) {
                    binder.bindEntityHierarchy(entityHierarchySource);
                }
            }
        }
    }
}

