/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;

public class DiscriminatorTypeImpl<O>
extends ConvertedBasicTypeImpl<O>
implements DiscriminatorType<O> {
    private final JavaType<O> domainJavaType;
    private final BasicType<?> underlyingJdbcMapping;

    public DiscriminatorTypeImpl(BasicType<?> underlyingJdbcMapping, DiscriminatorConverter<O, ?> discriminatorValueConverter) {
        super(discriminatorValueConverter.getDiscriminatorName(), "Discriminator type " + discriminatorValueConverter.getDiscriminatorName(), underlyingJdbcMapping.getJdbcType(), discriminatorValueConverter);
        assert (underlyingJdbcMapping.getJdbcJavaType() == discriminatorValueConverter.getRelationalJavaType());
        this.domainJavaType = discriminatorValueConverter.getDomainJavaType();
        this.underlyingJdbcMapping = underlyingJdbcMapping;
    }

    @Override
    public BasicType<?> getUnderlyingJdbcMapping() {
        return this.underlyingJdbcMapping;
    }

    @Override
    public DiscriminatorConverter<O, ?> getValueConverter() {
        return (DiscriminatorConverter)super.getValueConverter();
    }

    @Override
    public Class<O> getJavaType() {
        return this.domainJavaType.getJavaTypeClass();
    }

    @Override
    public boolean canDoExtraction() {
        return this.underlyingJdbcMapping.canDoExtraction();
    }

    @Override
    public JavaType<O> getExpressibleJavaType() {
        return this.domainJavaType;
    }
}

