/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.cache.CaffeineStatsCounter;
import java.util.concurrent.TimeUnit;
import org.keycloak.Config;
import org.keycloak.cache.AlternativeLookupProvider;
import org.keycloak.cache.AlternativeLookupProviderFactory;
import org.keycloak.cache.DefaultAlternativeLookupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class DefaultAlternativeLookupProviderFactory
implements AlternativeLookupProviderFactory {
    private Cache<String, String> lookupCache;

    public String getId() {
        return "default";
    }

    public AlternativeLookupProvider create(KeycloakSession session) {
        return new DefaultAlternativeLookupProvider(this.lookupCache);
    }

    public void init(Config.Scope config) {
        Integer maximumSize = config.getInt("maximumSize", Integer.valueOf(1000));
        Integer expireAfter = config.getInt("expireAfter", Integer.valueOf(60));
        CaffeineStatsCounter metrics = new CaffeineStatsCounter((MeterRegistry)Metrics.globalRegistry, "lookup");
        this.lookupCache = Caffeine.newBuilder().maximumSize((long)maximumSize.intValue()).expireAfterAccess((long)expireAfter.intValue(), TimeUnit.MINUTES).recordStats(() -> metrics).build();
        metrics.registerSizeMetric(this.lookupCache);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.lookupCache.cleanUp();
        this.lookupCache = null;
    }
}

