/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;

public class UniCreateFromKnownItem<T>
extends AbstractUni<T> {
    private final T item;

    public UniCreateFromKnownItem(T item) {
        this.item = item;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        new KnownItemSubscription(subscriber).forward();
    }

    private class KnownItemSubscription
    implements UniSubscription {
        private final UniSubscriber<? super T> subscriber;
        private volatile boolean cancelled = false;

        private KnownItemSubscription(UniSubscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        private void forward() {
            this.subscriber.onSubscribe(this);
            if (!this.cancelled) {
                this.subscriber.onItem(UniCreateFromKnownItem.this.item);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }
    }
}

