/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractBaseJWTValidator;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.JsonWebToken;

public abstract class AbstractJWTClientValidator
extends AbstractBaseJWTValidator {
    private static final Logger logger = Logger.getLogger(AbstractJWTClientValidator.class);
    protected final ClientAuthenticationFlowContext context;
    protected final RealmModel realm;
    protected final SignatureValidator signatureValidator;
    protected final String clientAuthenticatorProviderId;
    protected String expectedClientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";

    public AbstractJWTClientValidator(ClientAuthenticationFlowContext context, SignatureValidator signatureValidator, String clientAuthenticatorProviderId) throws Exception {
        super(context.getSession(), (ClientAssertionState)context.getState(ClientAssertionState.class, ClientAssertionState.supplier()));
        this.context = context;
        this.realm = context.getRealm();
        this.signatureValidator = signatureValidator;
        this.clientAuthenticatorProviderId = clientAuthenticatorProviderId;
    }

    public ClientAuthenticationFlowContext getContext() {
        return this.context;
    }

    public ClientModel getClient() {
        return this.clientAssertionState.getClient();
    }

    public boolean validate() {
        return this.validateClientAssertionParameters() && this.validateClient() && this.validateSignatureAlgorithm(this.getExpectedSignatureAlgorithm()) && this.validateSignature() && this.validateTokenAudience(this.getExpectedAudiences(), this.isMultipleAudienceAllowed()) && this.validateTokenActive(this.getAllowedClockSkew(), this.getMaximumExpirationTime(), this.isReusePermitted());
    }

    private boolean validateClientAssertionParameters() {
        String clientAssertionType = this.clientAssertionState.getClientAssertionType();
        String clientAssertion = this.clientAssertionState.getClientAssertion();
        if (clientAssertionType == null) {
            return this.failure("Parameter client_assertion_type is missing");
        }
        if (!this.expectedClientAssertionType.equals(clientAssertionType)) {
            return this.failure("Parameter client_assertion_type has value '" + clientAssertionType + "' but expected is '" + this.expectedClientAssertionType + "'");
        }
        if (clientAssertion == null) {
            return this.failure("client_assertion parameter missing");
        }
        return true;
    }

    private boolean validateClient() {
        JsonWebToken token = this.clientAssertionState.getToken();
        String clientId = token.getSubject();
        if (clientId == null) {
            logger.debug((Object)"Can't identify client. Subject missing on JWT token");
            return this.failure("Token sub claim is required");
        }
        String clientIdParam = (String)this.context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"client_id");
        if (clientIdParam != null && !clientIdParam.equals(clientId)) {
            logger.debug((Object)"client_id parameter does not match JWT subject");
            return this.failure("client_id parameter does not match sub claim");
        }
        String expectedTokenIssuer = this.getExpectedTokenIssuer();
        if (expectedTokenIssuer != null && !expectedTokenIssuer.equals(token.getIssuer())) {
            return false;
        }
        ClientModel client = this.clientAssertionState.getClient();
        if (client == null) {
            return this.failure(AuthenticationFlowError.CLIENT_NOT_FOUND);
        }
        this.context.getEvent().client(client.getClientId());
        this.context.setClient(client);
        if (!client.isEnabled()) {
            return this.failure(AuthenticationFlowError.CLIENT_DISABLED);
        }
        if (this.clientAuthenticatorProviderId != null && !this.clientAuthenticatorProviderId.equals(client.getClientAuthenticatorType())) {
            logger.debug((Object)"Not configured authenticator for client, ignoring");
            return false;
        }
        return true;
    }

    private boolean validateSignature() {
        return this.signatureValidator.verifySignature(this);
    }

    public boolean failure(String errorDescription) {
        return this.failure(errorDescription, Response.Status.BAD_REQUEST.getStatusCode());
    }

    public boolean failure(String errorDescription, int statusCode) {
        return this.failure("invalid_client", errorDescription, statusCode);
    }

    public boolean failure(String error, String errorDescription, int statusCode) {
        Response challengeResponse = ClientAuthUtil.errorResponse(statusCode, error, errorDescription);
        return this.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, challengeResponse);
    }

    private boolean failure(AuthenticationFlowError error) {
        return this.failure(error, null);
    }

    private boolean failure(AuthenticationFlowError error, Response response) {
        this.context.failure(error, response);
        return false;
    }

    @Override
    protected void failureCallback(String errorDescription) {
        this.failure(errorDescription);
    }

    protected abstract String getExpectedTokenIssuer();

    protected abstract List<String> getExpectedAudiences();

    protected abstract boolean isMultipleAudienceAllowed();

    protected abstract int getAllowedClockSkew();

    protected abstract int getMaximumExpirationTime();

    protected abstract boolean isReusePermitted();

    protected abstract String getExpectedSignatureAlgorithm();

    public static interface SignatureValidator {
        public boolean verifySignature(AbstractJWTClientValidator var1);
    }
}

