/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.oauth2;

import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism.oauth2.OAuth2Client;
import org.wildfly.security.mechanism.oauth2.OAuth2InitialClientMessage;
import org.wildfly.security.sasl.util.AbstractSaslClient;

final class OAuth2SaslClient
extends AbstractSaslClient {
    private static final int S_FIRST_MESSAGE = 1;
    private static final int S_FINAL_SERVER_RESPONSE = 2;
    private final OAuth2Client oauth2Client;

    OAuth2SaslClient(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId, OAuth2Client oauth2Client) {
        super(mechanismName, protocol, serverName, callbackHandler, authorizationId, true, ElytronMessages.saslOAuth2);
        this.oauth2Client = oauth2Client;
        this.setNegotiationState(1);
    }

    public void dispose() throws SaslException {
        this.setNegotiationState(-1);
    }

    protected byte[] evaluateMessage(int state, byte[] challenge) throws SaslException {
        boolean ok = false;
        try {
            switch (state) {
                case 1: {
                    if (challenge.length != 0) {
                        throw ElytronMessages.saslOAuth2.mechInitialChallengeMustBeEmpty().toSaslException();
                    }
                    OAuth2InitialClientMessage initialResponse = this.oauth2Client.getInitialResponse();
                    this.setNegotiationState(2);
                    ok = true;
                    byte[] byArray = initialResponse.getMessage();
                    return byArray;
                }
                case 2: {
                    byte[] finalMessage = this.oauth2Client.handleServerResponse(challenge);
                    if (finalMessage == null) {
                        this.negotiationComplete();
                        ok = true;
                    }
                    byte[] byArray = finalMessage;
                    return byArray;
                }
            }
            try {
                throw Assert.impossibleSwitchCase((int)state);
            }
            catch (AuthenticationMechanismException e) {
                throw e.toSaslException();
            }
        }
        finally {
            if (!ok) {
                this.setNegotiationState(-1);
            }
        }
    }
}

