# -*- coding: binary -*-

require 'spec_helper'

RSpec.describe Msf::Exploit::Remote::HTTP::Kubernetes::AuthParser do
  let(:valid_auth_response) do
    {
      "kind": "SelfSubjectRulesReview",
      "apiVersion": "authorization.k8s.io/v1",
      "metadata": {
        "creationTimestamp": nil
      },
      "spec": {},
      "status": {
        "resourceRules": [
          {
            "verbs": [
              "get",
              "list"
            ],
            "apiGroups": [
              "*"
            ],
            "resources": [
              "pod",
              "job"
            ],
            "resourceNames": [
              "test-resource"
            ]
          },
        ],
        "nonResourceRules": [
          {
            "verbs": [
              "get",
            ],
            "nonResourceURLs": [
              "/apis/*",
              "/version",
            ]
          }
        ],
        "incomplete": false
      }
    }.deep_symbolize_keys
  end

  let(:subject) { described_class.new(valid_auth_response) }

  describe '#as_table' do
    it 'returns the parsed list of auth rules as a table' do
      expected = {
        columns: ['Resources', 'Non-Resource URLs', 'Resource Names', 'Verbs'],
        rows: [
          ["job.*", "[]", "[test-resource]", "[get list]"],
          ["pod.*", "[]", "[test-resource]", "[get list]"],
          ["", "[/apis/*]", "[]", "[get]"],
          ["", "[/version]", "[]", "[get]"]
        ]
      }
      expect(subject.as_table).to eq(expected)
    end
  end
end
