/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.spi.OracleResourceProvider;

public final class InstalledProviders<T extends OracleResourceProvider> {
    private static final Logger LOGGER = Logger.getLogger(InstalledProviders.class.getName());
    private final Map<String, T> providers;

    private InstalledProviders(Map<String, T> providers) {
        this.providers = Collections.unmodifiableMap(new HashMap<String, T>(providers));
    }

    T get(String name) {
        return (T)((OracleResourceProvider)this.providers.get(name));
    }

    public Collection<String> getNames() {
        return Collections.unmodifiableSet(this.providers.keySet());
    }

    public static <T extends OracleResourceProvider> InstalledProviders<T> load(ResourceType<T, ?> resourceType) {
        TreeMap providers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        InstalledProviders.loadFromServiceLoader(resourceType.getProviderClass(), providers);
        return new InstalledProviders(providers);
    }

    private static <T extends OracleResourceProvider> void loadFromServiceLoader(Class<T> providerClass, Map<String, T> providers) {
        try {
            ServiceLoader<OracleResourceProvider> serviceLoader = ServiceLoader.load(providerClass);
            for (OracleResourceProvider provider : serviceLoader) {
                OracleResourceProvider previousProvider;
                String name = provider.getName();
                if (name == null || (previousProvider = providers.putIfAbsent(name, provider)) == null) continue;
                InstalledProviders.log(Level.WARNING, "loadFromServiceLoader", String.format("Multiple implementations of %s found with name \"%s\". Both %s and %s have the same name.", providerClass.getName(), name, provider.getClass().getName(), previousProvider.getClass().getName()));
            }
        }
        catch (Exception | ServiceConfigurationError exception) {
            InstalledProviders.log(Level.WARNING, "loadFromServiceLoader", String.format("A failure occurred when loading implementations of %s using java.util.ServiceLoader. This failure may prevent Oracle JDBC from using all available implementations of %1$s.", providerClass.getName()), exception);
        }
    }

    private static void log(Level level, String methodName, String message) {
        LOGGER.logp(level, InstalledProviders.class.getName(), methodName, message);
    }

    private static void log(Level level, String methodName, String message, Throwable throwable) {
        LOGGER.logp(level, InstalledProviders.class.getName(), methodName, message, throwable);
    }
}

