/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableBufferImpl;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.HeapNonNativeWritableBufferImpl;
import com.yahoo.memory.HeapWritableBufferImpl;
import com.yahoo.memory.HeapWritableMemoryImpl;
import com.yahoo.memory.NonNativeWritableMemoryImpl;
import com.yahoo.memory.Util;
import java.nio.ByteOrder;

final class HeapNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private static final int id = 32;
    private final Object unsafeObj;
    private final byte typeId;

    HeapNonNativeWritableMemoryImpl(Object unsafeObj, long regionOffset, long capacityBytes, int typeId) {
        super(unsafeObj, 0L, regionOffset, capacityBytes);
        this.unsafeObj = unsafeObj;
        this.typeId = (byte)(0x20 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return Util.isNativeOrder(byteOrder) ? new HeapWritableMemoryImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type) : new HeapNonNativeWritableMemoryImpl(this.unsafeObj, this.getRegionOffset(offsetBytes), capacityBytes, type);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | (readOnly ? (byte)1 : 0);
        return Util.isNativeOrder(byteOrder) ? new HeapWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, (BaseWritableMemoryImpl)this) : new HeapNonNativeWritableBufferImpl(this.unsafeObj, this.getRegionOffset(), this.getCapacity(), type, (BaseWritableMemoryImpl)this);
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

