"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignatureStream = void 0;
const stream_1 = require("stream");
const serialize_1 = require("@aws-crypto/serialize");
class SignatureStream extends stream_1.Transform {
    _signer;
    constructor(getSigner) {
        super();
        const value = getSigner && getSigner();
        Object.defineProperty(this, '_signer', { value, enumerable: true });
    }
    _transform(chunk, _encoding, callback) {
        // If we have a signer, push the data to it
        this._signer && this._signer.update(chunk);
        // forward the data on
        callback(null, chunk);
    }
    _flush(callback) {
        if (this._signer) {
            const signature = this._signer.awsCryptoSign();
            this.push((0, serialize_1.serializeSignatureInfo)(signature));
        }
        callback();
    }
}
exports.SignatureStream = SignatureStream;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2lnbmF0dXJlX3N0cmVhbS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zaWduYXR1cmVfc3RyZWFtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDOzs7QUFFdEMsbUNBQWtDO0FBRWxDLHFEQUE4RDtBQUk5RCxNQUFhLGVBQWdCLFNBQVEsa0JBQVM7SUFDcEMsT0FBTyxDQUF3QjtJQUN2QyxZQUFZLFNBQXFCO1FBQy9CLEtBQUssRUFBRSxDQUFBO1FBQ1AsTUFBTSxLQUFLLEdBQUcsU0FBUyxJQUFJLFNBQVMsRUFBRSxDQUFBO1FBQ3RDLE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRSxFQUFFLEtBQUssRUFBRSxVQUFVLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQTtJQUNyRSxDQUFDO0lBRUQsVUFBVSxDQUNSLEtBQVUsRUFDVixTQUFpQixFQUNqQixRQUF5RDtRQUV6RCwyQ0FBMkM7UUFDM0MsSUFBSSxDQUFDLE9BQU8sSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQTtRQUMxQyxzQkFBc0I7UUFDdEIsUUFBUSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQTtJQUN2QixDQUFDO0lBRUQsTUFBTSxDQUFDLFFBQStCO1FBQ3BDLElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNoQixNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsRUFBRSxDQUFBO1lBQzlDLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBQSxrQ0FBc0IsRUFBQyxTQUFTLENBQUMsQ0FBQyxDQUFBO1NBQzdDO1FBQ0QsUUFBUSxFQUFFLENBQUE7SUFDWixDQUFDO0NBQ0Y7QUExQkQsMENBMEJDIn0=