/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.jetbrains.python.debugger.PyStackFrameInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PyThreadInfo {
    private final String myId;
    @NonNls
    private final String myName;
    private List<PyStackFrameInfo> myFrames;
    private State myState;
    private int myStopReason;
    private String myMessage;

    public PyThreadInfo(String id, String name2, List<PyStackFrameInfo> frames, int stopReason, String message) {
        this.myId = id;
        this.myName = name2;
        this.myFrames = frames != null && !frames.isEmpty() ? Collections.unmodifiableList(frames) : null;
        this.myStopReason = stopReason;
        this.myMessage = message;
    }

    public String getId() {
        return this.myId;
    }

    public boolean isPydevThread() {
        return "-1".equals(this.myId);
    }

    @NonNls
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getMessage() {
        return this.myMessage;
    }

    public void setMessage(@Nullable String message) {
        this.myMessage = message;
    }

    @Nullable
    public synchronized List<PyStackFrameInfo> getFrames() {
        return this.myFrames;
    }

    public synchronized State getState() {
        return this.myState;
    }

    public synchronized void updateState(State state2, List<PyStackFrameInfo> frames) {
        this.myState = state2;
        this.myFrames = frames != null && !frames.isEmpty() ? Collections.unmodifiableList(frames) : null;
    }

    public void setStopReason(int stopReason) {
        this.myStopReason = stopReason;
    }

    public int getStopReason() {
        return this.myStopReason;
    }

    public boolean isStopOnBreakpoint() {
        return this.myStopReason == 111;
    }

    public boolean isExceptionBreak() {
        return this.myStopReason == 122 || this.myStopReason == 137;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyThreadInfo that = (PyThreadInfo)o;
        return !(this.myId != null ? !this.myId.equals(that.myId) : that.myId != null);
    }

    public int hashCode() {
        return this.myId != null ? this.myId.hashCode() : 0;
    }

    public static enum State {
        RUNNING,
        SUSPENDED,
        KILLED;

    }
}

