/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.ActivityId;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.vcs.log.Hash;
import git4idea.DialogManager;
import git4idea.GitActivity;
import git4idea.GitApplyChangesNotification;
import git4idea.GitUtil;
import git4idea.actions.GitOperationActionBase;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitFreezingProcess;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0003\u001e\u001f B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0012\u0010\u0011\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006!"}, d2={"Lgit4idea/actions/GitAbortOperationAction;", "Lgit4idea/actions/GitOperationActionBase;", "repositoryState", "Lcom/intellij/dvcs/repo/Repository$State;", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "gitCommand", "Lgit4idea/commands/GitCommand;", "<init>", "(Lcom/intellij/dvcs/repo/Repository$State;Ljava/lang/String;Lgit4idea/commands/GitCommand;)V", "getOperationName", "()Ljava/lang/String;", "operationNameCapitalised", "Lorg/jetbrains/annotations/NotNull;", "notificationSuccessDisplayId", "getNotificationSuccessDisplayId", "notificationErrorDisplayId", "getNotificationErrorDisplayId", "getMainToolbarIcon", "Ljavax/swing/Icon;", "performInBackground", "", "repository", "Lgit4idea/repo/GitRepository;", "confirmAbort", "", "doAbort", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Merge", "CherryPick", "Revert", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitAbortOperationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitAbortOperationAction.kt\ngit4idea/actions/GitAbortOperationAction\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 GitApplyChangesConflictNotification.kt\ngit4idea/GitApplyChangesNotification$Companion\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,120:1\n41#2,11:121\n28#3,3:132\n31#3,2:136\n33#3:139\n13472#4:135\n13473#4:138\n*S KotlinDebug\n*F\n+ 1 GitAbortOperationAction.kt\ngit4idea/actions/GitAbortOperationAction\n*L\n68#1:121,11\n72#1:132,3\n72#1:136,2\n72#1:139\n72#1:135\n72#1:138\n*E\n"})
public abstract class GitAbortOperationAction
extends GitOperationActionBase {
    @NotNull
    private final Repository.State repositoryState;
    @NotNull
    private final String operationName;
    @NotNull
    private final GitCommand gitCommand;
    @NotNull
    private final String operationNameCapitalised;

    public GitAbortOperationAction(@NotNull Repository.State repositoryState, @NotNull String operationName, @NotNull GitCommand gitCommand) {
        Intrinsics.checkNotNullParameter((Object)repositoryState, (String)"repositoryState");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)gitCommand, (String)"gitCommand");
        super(repositoryState);
        this.repositoryState = repositoryState;
        this.operationName = operationName;
        this.gitCommand = gitCommand;
        String string = StringUtil.capitalizeWords((String)this.operationName, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalizeWords(...)");
        this.operationNameCapitalised = string;
    }

    @Override
    @NotNull
    protected final String getOperationName() {
        return this.operationName;
    }

    @NotNull
    protected abstract String getNotificationSuccessDisplayId();

    @NotNull
    protected abstract String getNotificationErrorDisplayId();

    @Override
    @NotNull
    public final Icon getMainToolbarIcon() {
        Icon icon = AllIcons.Vcs.Abort;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Abort");
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performInBackground(@NotNull GitRepository repository2) {
        void $this$forEach$iv$iv;
        GitApplyChangesNotification.Companion title$iv;
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        if (!this.confirmAbort(repository2)) {
            return;
        }
        Object[] objectArray = new Object[]{this.operationNameCapitalised};
        String string = GitBundle.message("abort.operation.progress.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Project project$iv = repository2.getProject();
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask22 = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)((Object)title$iv), cancellable$iv, this, repository2){
            final /* synthetic */ GitAbortOperationAction this$0;
            final /* synthetic */ GitRepository $repository$inlined;
            {
                this.this$0 = gitAbortOperationAction;
                this.$repository$inlined = gitRepository;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                GitAbortOperationAction.access$doAbort(this.this$0, this.$repository$inlined, indicator2);
            }
        });
        title$iv = GitApplyChangesNotification.Companion;
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        project$iv = project;
        boolean $i$f$expireAll = false;
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(GitApplyChangesNotification.class, project$iv);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        Object[] $i$f$runBackgroundableTask22 = notificationArray;
        boolean $i$f$forEach = false;
        for (void element$iv$iv : $this$forEach$iv$iv) {
            GitApplyChangesNotification it$iv = (GitApplyChangesNotification)element$iv$iv;
            boolean bl = false;
            if (!(it$iv instanceof GitApplyChangesNotification.ExpireAfterAbort)) continue;
            ((Notification)it$iv).expire();
        }
    }

    private final boolean confirmAbort(GitRepository repository2) {
        Object[] objectArray = new Object[]{this.operationNameCapitalised};
        String string = GitBundle.message("abort.operation.dialog.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        Object[] objectArray2 = new Object[]{this.operationName, GitUtil.mention(repository2)};
        String string2 = GitBundle.message("abort.operation.dialog.msg", objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        return DialogManager.showOkCancelDialog(repository2.getProject(), message, title, GitBundle.message("abort", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon()) == 0;
    }

    private final void doAbort(GitRepository repository2, ProgressIndicator indicator) {
        Project project = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = GitBundle.message("abort", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        new GitFreezingProcess(project2, string, () -> GitAbortOperationAction.doAbort$lambda$2(project2, this, indicator, repository2)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doAbort$lambda$2(Project $project, GitAbortOperationAction this$0, ProgressIndicator $indicator, GitRepository $repository) {
        Object object = new Object[]{this$0.operationName};
        object = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)$project, (String)GitBundle.message("activity.name.abort.command", object), (ActivityId)GitActivity.Abort);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)object;
            boolean bl = false;
            Object[] objectArray = new Object[]{this$0.gitCommand.name(), GitUtil.mention($repository)};
            $indicator.setText2(GitBundle.message("abort.operation.indicator.text", objectArray));
            Hash startHash = GitUtil.getHead($repository);
            Collection<GitChangeUtils.GitDiffChange> collection = GitChangeUtils.getStagedChanges($project, $repository.getRoot());
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getStagedChanges(...)");
            Collection<GitChangeUtils.GitDiffChange> stagedChanges = collection;
            GitLineHandler handler = new GitLineHandler($project, $repository.getRoot(), this$0.gitCommand);
            String[] stringArray = new String[]{"--abort"};
            handler.addParameters(stringArray);
            GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
            Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
            GitCommandResult result2 = gitCommandResult;
            if (!result2.success()) {
                Object[] objectArray2 = new Object[]{this$0.operationNameCapitalised};
                VcsNotifier.getInstance((Project)$project).notifyError(this$0.getNotificationErrorDisplayId(), GitBundle.message("abort.operation.failed", objectArray2), result2.getErrorOutputAsHtmlString(), true);
            } else {
                Object[] objectArray3 = new Object[]{this$0.operationNameCapitalised};
                VcsNotifier.getInstance((Project)$project).notifySuccess(this$0.getNotificationSuccessDisplayId(), "", GitBundle.message("abort.operation.succeeded", objectArray3));
                GitUtil.updateAndRefreshChangedVfs($repository, startHash);
                RefreshVFsSynchronously.INSTANCE.refresh(stagedChanges, true);
                if (this$0.repositoryState == Repository.State.GRAFTING) {
                    ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx((Project)$project);
                    Intrinsics.checkNotNullExpressionValue((Object)changeListManagerEx, (String)"getInstanceEx(...)");
                    ChangeListManagerEx changeListManager = changeListManagerEx;
                    for (LocalChangeList list : changeListManager.getChangeLists()) {
                        Object object2 = list.getData();
                        ChangeListData changeListData = object2 instanceof ChangeListData ? (ChangeListData)object2 : null;
                        boolean bl2 = changeListData != null ? changeListData.getAutomatic() : false;
                        boolean isAutomatic = bl2;
                        if (!isAutomatic) continue;
                        changeListManager.editChangeListData(list.getName(), null);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ void access$doAbort(GitAbortOperationAction $this, GitRepository repository2, ProgressIndicator indicator) {
        $this.doAbort(repository2, indicator);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lgit4idea/actions/GitAbortOperationAction$CherryPick;", "Lgit4idea/actions/GitAbortOperationAction;", "<init>", "()V", "notificationSuccessDisplayId", "", "getNotificationSuccessDisplayId", "()Ljava/lang/String;", "notificationErrorDisplayId", "getNotificationErrorDisplayId", "intellij.vcs.git"})
    public static final class CherryPick
    extends GitAbortOperationAction {
        @NotNull
        private final String notificationSuccessDisplayId;
        @NotNull
        private final String notificationErrorDisplayId;

        public CherryPick() {
            String string = GitBundle.message("abort.operation.cherry.pick.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            GitCommand gitCommand = GitCommand.CHERRY_PICK;
            Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"CHERRY_PICK");
            super(Repository.State.GRAFTING, string, gitCommand);
            this.notificationSuccessDisplayId = "git.cherry.pick.abort.success";
            this.notificationErrorDisplayId = "git.cherry.pick.abort.failed";
        }

        @Override
        @NotNull
        protected String getNotificationSuccessDisplayId() {
            return this.notificationSuccessDisplayId;
        }

        @Override
        @NotNull
        protected String getNotificationErrorDisplayId() {
            return this.notificationErrorDisplayId;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lgit4idea/actions/GitAbortOperationAction$Merge;", "Lgit4idea/actions/GitAbortOperationAction;", "<init>", "()V", "notificationSuccessDisplayId", "", "getNotificationSuccessDisplayId", "()Ljava/lang/String;", "notificationErrorDisplayId", "getNotificationErrorDisplayId", "intellij.vcs.git"})
    public static final class Merge
    extends GitAbortOperationAction {
        @NotNull
        private final String notificationSuccessDisplayId;
        @NotNull
        private final String notificationErrorDisplayId;

        public Merge() {
            String string = GitBundle.message("abort.operation.merge.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            GitCommand gitCommand = GitCommand.MERGE;
            Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"MERGE");
            super(Repository.State.MERGING, string, gitCommand);
            this.notificationSuccessDisplayId = "git.merge.abort.success";
            this.notificationErrorDisplayId = "git.merge.abort.failed";
        }

        @Override
        @NotNull
        protected String getNotificationSuccessDisplayId() {
            return this.notificationSuccessDisplayId;
        }

        @Override
        @NotNull
        protected String getNotificationErrorDisplayId() {
            return this.notificationErrorDisplayId;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lgit4idea/actions/GitAbortOperationAction$Revert;", "Lgit4idea/actions/GitAbortOperationAction;", "<init>", "()V", "notificationSuccessDisplayId", "", "getNotificationSuccessDisplayId", "()Ljava/lang/String;", "notificationErrorDisplayId", "getNotificationErrorDisplayId", "intellij.vcs.git"})
    public static final class Revert
    extends GitAbortOperationAction {
        @NotNull
        private final String notificationSuccessDisplayId;
        @NotNull
        private final String notificationErrorDisplayId;

        public Revert() {
            String string = GitBundle.message("abort.operation.revert.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            GitCommand gitCommand = GitCommand.REVERT;
            Intrinsics.checkNotNullExpressionValue((Object)gitCommand, (String)"REVERT");
            super(Repository.State.REVERTING, string, gitCommand);
            this.notificationSuccessDisplayId = "git.revert.abort.success";
            this.notificationErrorDisplayId = "git.revert.abort.failed";
        }

        @Override
        @NotNull
        protected String getNotificationSuccessDisplayId() {
            return this.notificationSuccessDisplayId;
        }

        @Override
        @NotNull
        protected String getNotificationErrorDisplayId() {
            return this.notificationErrorDisplayId;
        }
    }
}

