/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShNotification;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.statistics.ShCounterUsagesCollector;
import com.intellij.sh.utils.ExternalServicesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShShfmtFormatterUtil {
    private static final Logger LOG = Logger.getInstance(ShShfmtFormatterUtil.class);
    private static final Key<Boolean> UPDATE_NOTIFICATION_SHOWN = Key.create((String)"SHFMT_UPDATE");
    @NlsSafe
    private static final String SHFMT = "shfmt";
    @NlsSafe
    private static final String OLD_SHFMT = "old_shfmt";
    @NlsSafe
    private static final String SHFMT_VERSION = "v3.3.1";
    @NlsSafe
    private static final String ARCH_i386 = "_386";
    @NlsSafe
    private static final String ARCH_x86_64 = "_amd64";
    @NlsSafe
    private static final String ARCH_ARM64 = "_arm64";
    @NlsSafe
    private static final String WINDOWS = "_windows";
    @NlsSafe
    private static final String WINDOWS_EXTENSION = ".exe";
    @NlsSafe
    private static final String MAC = "_darwin";
    @NlsSafe
    private static final String LINUX = "_linux";
    @NlsSafe
    private static final String FREE_BSD = "_freebsd";

    public static void download(@NotNull Project project, @NotNull Runnable onSuccess, @NotNull Runnable onFailure) {
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(0);
        }
        if (onSuccess == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(1);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(2);
        }
        ShShfmtFormatterUtil.download(project, onSuccess, onFailure, false);
    }

    private static void download(final @NotNull Project project, final @NotNull Runnable onSuccess, final @NotNull Runnable onFailure, final boolean withReplace) {
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(3);
        }
        if (onSuccess == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(4);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(5);
        }
        Task.Backgroundable task = new Task.Backgroundable(project, ShBundle.message("sh.label.download.shfmt.formatter", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                EelDescriptor eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project);
                EelApi eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)eelDescriptor);
                EelPlatform eelPlatform = eel.getPlatform();
                Path downloadPath = ExternalServicesUtil.computeDownloadPath(eel);
                if (!Files.exists(downloadPath, new LinkOption[0])) {
                    try {
                        Files.createDirectory(downloadPath, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Path formatter = downloadPath.resolve(ShShfmtFormatterUtil.SHFMT + (EelPlatformKt.isWindows((EelPlatform)eelPlatform) ? ShShfmtFormatterUtil.WINDOWS_EXTENSION : ""));
                Path oldFormatter = downloadPath.resolve(ShShfmtFormatterUtil.OLD_SHFMT + (EelPlatformKt.isWindows((EelPlatform)eelPlatform) ? ShShfmtFormatterUtil.WINDOWS_EXTENSION : ""));
                if (Files.exists(formatter, new LinkOption[0])) {
                    if (withReplace) {
                        boolean successful = ShShfmtFormatterUtil.renameOldFormatter(formatter.toFile(), oldFormatter.toFile(), onFailure);
                        if (!successful) {
                            return;
                        }
                    } else {
                        ShShfmtFormatterUtil.setupFormatterPath(project, formatter.toFile(), onSuccess, onFailure);
                        return;
                    }
                }
                String downloadName = ShShfmtFormatterUtil.SHFMT + (EelPlatformKt.isWindows((EelPlatform)eelPlatform) ? ShShfmtFormatterUtil.WINDOWS_EXTENSION : "");
                DownloadableFileService service = DownloadableFileService.getInstance();
                DownloadableFileDescription description = service.createFileDescription(ShShfmtFormatterUtil.getShfmtDistributionLink(eel.getPlatform()), downloadName);
                FileDownloader downloader = service.createDownloader(Collections.singletonList(description), downloadName);
                try {
                    File file;
                    List pairs = downloader.download(downloadPath.toFile());
                    Pair first = (Pair)ContainerUtil.getFirstItem((List)pairs);
                    File file2 = file = first != null ? (File)first.first : null;
                    if (file != null) {
                        FileUtil.setExecutable((File)file);
                        ShSettings.setShfmtPath(project, file.getCanonicalPath());
                        if (withReplace) {
                            LOG.info("Remove old formatter");
                            FileUtil.delete((Path)oldFormatter);
                        }
                        ApplicationManager.getApplication().invokeLater(onSuccess);
                        ShCounterUsagesCollector.EXTERNAL_FORMATTER_DOWNLOADED_EVENT_ID.log();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Can't download shfmt formatter", (Throwable)e);
                    if (withReplace) {
                        ShShfmtFormatterUtil.rollbackToOldFormatter(formatter.toFile(), oldFormatter.toFile());
                    }
                    ApplicationManager.getApplication().invokeLater(onFailure);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sh/formatter/ShShfmtFormatterUtil$1", "run"));
            }
        };
        BackgroundableProcessIndicator processIndicator = new BackgroundableProcessIndicator(task);
        processIndicator.setIndeterminate(false);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)processIndicator);
    }

    private static void setupFormatterPath(@NotNull Project project, @NotNull File formatter, @NotNull Runnable onSuccess, @NotNull Runnable onFailure) {
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(6);
        }
        if (formatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(7);
        }
        if (onSuccess == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(8);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(9);
        }
        try {
            String formatterPath = formatter.getCanonicalPath();
            if (ShSettings.getShfmtPath(project).equals(formatterPath)) {
                LOG.info("Shfmt formatter already downloaded");
            } else {
                ShSettings.setShfmtPath(project, formatterPath);
            }
            if (!formatter.canExecute()) {
                FileUtil.setExecutable((File)formatter);
            }
            ApplicationManager.getApplication().invokeLater(onSuccess);
        }
        catch (IOException e) {
            LOG.warn("Can't evaluate formatter path or make it executable", (Throwable)e);
            ApplicationManager.getApplication().invokeLater(onFailure);
        }
    }

    private static boolean renameOldFormatter(@NotNull File formatter, @NotNull File oldFormatter, @NotNull Runnable onFailure) {
        if (formatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(10);
        }
        if (oldFormatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(11);
        }
        if (onFailure == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(12);
        }
        LOG.info("Rename formatter to the temporary filename");
        try {
            FileUtil.rename((File)formatter, (File)oldFormatter);
        }
        catch (IOException e) {
            LOG.info("Can't rename formatter to the temporary filename", (Throwable)e);
            ApplicationManager.getApplication().invokeLater(onFailure);
            return false;
        }
        return true;
    }

    private static void rollbackToOldFormatter(@NotNull File formatter, @NotNull File oldFormatter) {
        if (formatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(13);
        }
        if (oldFormatter == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(14);
        }
        LOG.info("Update failed, rollback");
        try {
            FileUtil.rename((File)oldFormatter, (File)formatter);
        }
        catch (IOException e) {
            LOG.info("Can't rollback formatter after failed update", (Throwable)e);
        }
        FileUtil.delete((File)oldFormatter);
    }

    public static boolean isValidPath(@Nullable String path) {
        if (path == null) {
            return false;
        }
        if (ShSettings.I_DO_MIND_SUPPLIER.get().equals(path)) {
            return true;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            return false;
        }
        return file.getName().contains(SHFMT);
    }

    static void checkShfmtForUpdate(@NotNull Project project) {
        Application application;
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(15);
        }
        if ((application = ApplicationManager.getApplication()).getUserData(UPDATE_NOTIFICATION_SHOWN) != null) {
            return;
        }
        application.putUserData(UPDATE_NOTIFICATION_SHOWN, (Object)true);
        if (application.isDispatchThread()) {
            application.executeOnPooledThread(() -> ShShfmtFormatterUtil.checkForUpdateInBackgroundThread(project));
        } else {
            ShShfmtFormatterUtil.checkForUpdateInBackgroundThread(project);
        }
    }

    private static void checkForUpdateInBackgroundThread(@NotNull Project project) {
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        Pair<String, String> newVersionAvailable = ShShfmtFormatterUtil.getVersionUpdate(project);
        if (newVersionAvailable == null) {
            return;
        }
        String currentVersion = (String)newVersionAvailable.first;
        String newVersion = (String)newVersionAvailable.second;
        Notification notification = ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.update.question", currentVersion, newVersion), NotificationType.INFORMATION);
        notification.setSuggestionType(true);
        notification.setDisplayId("sh.update.formatter");
        notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.update", new Object[0]), () -> {
            notification.expire();
            ShShfmtFormatterUtil.download(project, () -> ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.success.update", new Object[0]), NotificationType.INFORMATION).setDisplayId("sh.update.formatter.success").notify(project), () -> ShNotification.NOTIFICATION_GROUP.createNotification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.cannot.update", new Object[0]), NotificationType.ERROR).setDisplayId("sh.update.formatter.error").notify(project), true);
        }));
        notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.skip.version", new Object[0]), () -> {
            notification.expire();
            ShSettings.setSkippedShfmtVersion(SHFMT_VERSION);
        }));
        notification.notify(project);
    }

    private static Pair<String, String> getVersionUpdate(@NotNull Project project) {
        String updateVersion;
        SemVer updateVersionVer;
        if (project == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(17);
        }
        if ((updateVersionVer = SemVer.parseFromText((String)(updateVersion = StringsKt.removePrefix((String)SHFMT_VERSION, (CharSequence)"v")))) == null) {
            return null;
        }
        if (ShSettings.getSkippedShfmtVersion().equals(updateVersion)) {
            return null;
        }
        String path = ShSettings.getShfmtPath(project);
        if (ShSettings.I_DO_MIND_SUPPLIER.get().equals(path)) {
            return null;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            return null;
        }
        if (!file.getName().contains(SHFMT)) {
            return null;
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(path).withParameters(new String[]{"--version"});
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)3000);
            String stdout = processOutput.getStdout();
            String current = ShShfmtFormatterUtil.getVersionFromStdOut(stdout);
            if (current == null) {
                current = "unknown";
                return Pair.create((Object)current, (Object)updateVersion);
            }
            SemVer currentVersion = SemVer.parseFromText((String)current);
            if (currentVersion == null || updateVersionVer.isGreaterThan(currentVersion)) {
                return Pair.create((Object)current, (Object)updateVersion);
            }
            return null;
        }
        catch (ExecutionException e) {
            LOG.debug("Exception in process execution", (Throwable)e);
            return null;
        }
    }

    private static String getVersionFromStdOut(String stdout) {
        String[] lines;
        for (String line : lines = StringUtil.splitByLines((String)stdout)) {
            if ((line = line.trim().toLowerCase(Locale.ENGLISH)).isEmpty() || !Character.isDigit(line.charAt(0))) continue;
            return line;
        }
        return null;
    }

    @NotNull
    private static String getShfmtDistributionLink(@NotNull EelPlatform platform) {
        if (platform == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(18);
        }
        StringBuilder baseUrl = new StringBuilder("https://github.com/mvdan/sh/releases/download/").append(SHFMT_VERSION).append('/').append(SHFMT).append('_').append(SHFMT_VERSION);
        if (EelPlatformKt.isMac((EelPlatform)platform)) {
            baseUrl.append(MAC);
        } else if (EelPlatformKt.isLinux((EelPlatform)platform)) {
            baseUrl.append(LINUX);
        } else if (EelPlatformKt.isWindows((EelPlatform)platform)) {
            baseUrl.append(WINDOWS);
        } else if (EelPlatformKt.isFreeBSD((EelPlatform)platform)) {
            baseUrl.append(FREE_BSD);
        }
        if (EelPlatformKt.isX86_64((EelPlatform)platform)) {
            baseUrl.append(ARCH_x86_64);
        }
        if (EelPlatformKt.isX86((EelPlatform)platform)) {
            baseUrl.append(ARCH_i386);
        } else if (EelPlatformKt.isArm64((EelPlatform)platform)) {
            baseUrl.append(ARCH_ARM64);
        }
        if (EelPlatformKt.isWindows((EelPlatform)platform)) {
            baseUrl.append(WINDOWS_EXTENSION);
        }
        String string = baseUrl.toString();
        if (string == null) {
            ShShfmtFormatterUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailure";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFormatter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/formatter/ShShfmtFormatterUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/formatter/ShShfmtFormatterUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getShfmtDistributionLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupFormatterPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "renameOldFormatter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "rollbackToOldFormatter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkShfmtForUpdate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkForUpdateInBackgroundThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUpdate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getShfmtDistributionLink";
                break;
            }
            case 19: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19 -> new IllegalStateException(string);
        };
    }
}

