/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.config.PatternsListener;
import org.jetbrains.idea.svn.config.RepositoryUrlsListener;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesComponent;
import org.jetbrains.idea.svn.config.SvnIniFile;

public class RepositoryUrlFilter
implements PatternsListener {
    private final RepositoryUrlsListener myListener;
    private final SvnConfigureProxiesComponent myComponent;
    private final RepositoryUrlsListener myDefaultGroupListener;

    public RepositoryUrlFilter(@NotNull RepositoryUrlsListener listener2, @NotNull SvnConfigureProxiesComponent component, @NotNull RepositoryUrlsListener defaultGroupListener) {
        if (listener2 == null) {
            RepositoryUrlFilter.$$$reportNull$$$0(0);
        }
        if (component == null) {
            RepositoryUrlFilter.$$$reportNull$$$0(1);
        }
        if (defaultGroupListener == null) {
            RepositoryUrlFilter.$$$reportNull$$$0(2);
        }
        this.myListener = listener2;
        this.myComponent = component;
        this.myDefaultGroupListener = defaultGroupListener;
    }

    @Override
    public void onChange(String patterns, String exceptions) {
        Collection<String> urls = SvnApplicationSettings.getInstance().getCheckoutURLs();
        ArrayList<String> result = new ArrayList<String>();
        for (String url : urls) {
            if (!SvnIniFile.checkHostGroup(url, patterns, exceptions)) continue;
            result.add(url);
        }
        Collections.sort(result);
        this.myListener.onListChanged(result);
        this.notifyDefaultGroup(urls);
    }

    private void notifyDefaultGroup(@NotNull Collection<String> urls) {
        if (urls == null) {
            RepositoryUrlFilter.$$$reportNull$$$0(3);
        }
        List<String> filtered = this.myComponent.getGlobalGroupRepositories(urls);
        Collections.sort(filtered);
        this.myDefaultGroupListener.onListChanged(filtered);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultGroupListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/config/RepositoryUrlFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyDefaultGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

