/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeModel;

public class ShareDialog
extends RepositoryBrowserDialog {
    private String mySelectedURL;
    @NlsSafe
    @NotNull
    private final String myName;
    private JRadioButton myExisting;
    private JRadioButton mySameNameAsLocal;
    private JRadioButton myTrunk;
    private JBCheckBox myCreateStandard;
    private CommitMessage myCommitMessage;
    private JComponent myPrefferedFocused;

    public ShareDialog(Project project, @NlsSafe @NotNull String name) {
        if (name == null) {
            ShareDialog.$$$reportNull$$$0(0);
        }
        super(project, false, SvnBundle.message("label.point.to.repository.location", new Object[0]));
        this.myName = name;
        this.myExisting.setToolTipText(SvnBundle.message("radio.share.target.at.selected.repository.location", new Object[0]));
        this.mySameNameAsLocal.setToolTipText(SvnBundle.message("radio.share.target.in.new.folder", this.myName));
        this.myTrunk.setToolTipText(SvnBundle.message("radio.share.target.in.new.folder", this.myName + "/trunk"));
        this.updateTargetOptions(false);
        this.myRepositoriesLabel.setFont(this.myRepositoriesLabel.getFont().deriveFont(1));
        this.myPrefferedFocused = (JComponent)this.getRepositoryBrowser().getPreferredFocusedComponent();
    }

    public void init() {
        super.init();
        this.setTitle(SvnBundle.message("dialog.title.select.share.target", new Object[0]));
        this.setOKButtonText(SvnBundle.message("button.share", new Object[0]));
        this.getRepositoryBrowser().addChangeListener(e -> {
            Url url = this.getRepositoryBrowser().getSelectedSVNURL();
            boolean enabled = url != null && this.setTarget(url);
            this.updateTargetOptions(enabled);
            this.getOKAction().setEnabled(enabled);
        });
        this.getOKAction().setEnabled(this.getRepositoryBrowser().getSelectedURL() != null);
        ((RepositoryTreeModel)this.getRepositoryBrowser().getRepositoryTree().getModel()).setShowFiles(false);
        this.getRepositoryBrowser().getPreferredFocusedComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ShareDialog.this.myPrefferedFocused = (JComponent)ShareDialog.this.getRepositoryBrowser().getPreferredFocusedComponent();
            }
        });
    }

    private boolean setTarget(@NotNull Url url) {
        if (url == null) {
            ShareDialog.$$$reportNull$$$0(1);
        }
        try {
            this.myExisting.setText(url.toDecodedString());
            this.mySameNameAsLocal.setText(url.appendPath(this.myName, false).toDecodedString());
            this.myTrunk.setText(url.appendPath(this.myName, false).appendPath("trunk", false).toDecodedString());
            return true;
        }
        catch (SvnBindException e) {
            Messages.showErrorDialog((Project)this.myVCS.getProject(), (String)e.getMessage(), (String)SvnBundle.message("dialog.title.error", new Object[0]));
            return false;
        }
    }

    private void updateTargetOptions(boolean enabled) {
        if (!enabled) {
            this.myExisting.setText(this.myExisting.getToolTipText());
            this.mySameNameAsLocal.setText(this.mySameNameAsLocal.getToolTipText());
            this.myTrunk.setText(this.myTrunk.getToolTipText());
        }
        this.myExisting.setEnabled(enabled);
        this.mySameNameAsLocal.setEnabled(enabled);
        this.myTrunk.setEnabled(enabled);
        this.myCreateStandard.setEnabled(enabled && this.myTrunk.isSelected());
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myPrefferedFocused;
    }

    @Override
    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            ShareDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected void doOKAction() {
        this.mySelectedURL = this.getRepositoryBrowser().getSelectedURL();
        super.doOKAction();
    }

    @Override
    public String getSelectedURL() {
        return this.mySelectedURL;
    }

    @Override
    protected JPopupMenu createPopup(boolean toolWindow) {
        ActionPopupMenu menu = ShareDialog.createShortPopupForRepositoryDialog(this.getRepositoryBrowser());
        return menu.getComponent();
    }

    public static ActionPopupMenu createShortPopupForRepositoryDialog(RepositoryBrowserComponent browserComponent) {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultActionGroup newGroup = DefaultActionGroup.createPopupGroup((Supplier)ActionsBundle.messagePointer((String)"group.NewGroup.text", (Object[])new Object[0]));
        newGroup.add((AnAction)new RepositoryBrowserDialog.AddLocationAction(browserComponent));
        newGroup.add((AnAction)new RepositoryBrowserDialog.MkDirAction(browserComponent));
        group.add((AnAction)newGroup);
        group.addSeparator();
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction(browserComponent));
        group.add((AnAction)new RepositoryBrowserDialog.DiscardLocationAction(browserComponent));
        group.add((AnAction)new RepositoryBrowserDialog.DeleteAction(browserComponent));
        return ActionManager.getInstance().createActionPopupMenu("SvnShareDialog", (ActionGroup)group);
    }

    @Override
    public JComponent createCenterPanel() {
        JComponent repositoryPanel = super.createCenterPanel();
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, (Insets)JBUI.insets((int)1), 0, 0);
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        wrapper.add((Component)repositoryPanel, gb);
        ++gb.gridy;
        gb.fill = 0;
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.fill = 2;
        wrapper.add((Component)this.createFolderPanel(), gb);
        return wrapper;
    }

    @NotNull
    public ShareTarget getShareTarget() {
        if (this.myExisting.isSelected()) {
            ShareTarget shareTarget = ShareTarget.useSelected;
            if (shareTarget == null) {
                ShareDialog.$$$reportNull$$$0(3);
            }
            return shareTarget;
        }
        if (this.mySameNameAsLocal.isSelected()) {
            ShareTarget shareTarget = ShareTarget.useProjectName;
            if (shareTarget == null) {
                ShareDialog.$$$reportNull$$$0(4);
            }
            return shareTarget;
        }
        ShareTarget shareTarget = ShareTarget.trunkUnderProjectName;
        if (shareTarget == null) {
            ShareDialog.$$$reportNull$$$0(5);
        }
        return shareTarget;
    }

    public boolean createStandardStructure() {
        return this.myCreateStandard.isSelected();
    }

    @NotNull
    public String getCommitText() {
        String string = this.myCommitMessage.getComment();
        if (string == null) {
            ShareDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    private JComponent createFolderPanel() {
        Project project = this.myVCS.getProject();
        this.myCommitMessage = new CommitMessage(project){

            public Dimension getPreferredSize() {
                Dimension superValue = super.getPreferredSize();
                return new Dimension(superValue.width, Math.max(superValue.height, 90));
            }

            public void addNotify() {
                super.addNotify();
                ShareDialog.this.myCommitMessage.getEditorField().getFocusTarget().addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        ShareDialog.this.myPrefferedFocused = ShareDialog.this.myCommitMessage.getEditorField();
                    }
                });
            }
        };
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myCommitMessage);
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
        gb.insets.top = 5;
        JBLabel label = new JBLabel(SvnBundle.message("label.define.share.target", new Object[0]));
        label.setFont(label.getFont().deriveFont(1));
        panel2.add((Component)label, gb);
        gb.insets.top = 1;
        ButtonGroup bg = new ButtonGroup();
        this.myExisting = new JRadioButton();
        this.mySameNameAsLocal = new JRadioButton();
        this.myTrunk = new JRadioButton();
        bg.add(this.myExisting);
        bg.add(this.mySameNameAsLocal);
        bg.add(this.myTrunk);
        gb.insets.top = 1;
        ++gb.gridy;
        panel2.add((Component)this.myExisting, gb);
        ++gb.gridy;
        panel2.add((Component)this.mySameNameAsLocal, gb);
        ++gb.gridy;
        gb.insets.top = 5;
        panel2.add((Component)this.myTrunk, gb);
        this.myCreateStandard = new JBCheckBox(SvnBundle.message("checkbox.create.tags.branches", new Object[0]));
        this.myTrunk.addChangeListener(e -> this.myCreateStandard.setEnabled(this.myTrunk.isSelected()));
        this.myCreateStandard.setSelected(true);
        ++gb.gridy;
        gb.insets.top = 0;
        gb.insets.left = 10;
        panel2.add((Component)this.myCreateStandard, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.insets.top = 1;
        gb.insets.left = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        LocalChangeList list = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        String text = list.getComment();
        text = StringUtil.isEmptyOrSpaces((String)text) ? (list.hasDefaultName() ? "" : list.getName()) : text;
        this.myCommitMessage.setText(text);
        panel2.add((Component)this.myCommitMessage, gb);
        this.myCommitMessage.setSeparatorText(SvnBundle.message("separator.commit.comment.prefix", new Object[0]));
        for (EditChangelistSupport support : (EditChangelistSupport[])EditChangelistSupport.EP_NAME.getExtensions((AreaInstance)project)) {
            support.installSearch(this.myCommitMessage.getEditorField(), this.myCommitMessage.getEditorField());
        }
        this.myTrunk.setSelected(true);
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/ShareDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/ShareDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShareTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static enum ShareTarget {
        useSelected,
        useProjectName,
        trunkUnderProjectName;

    }
}

