/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.html;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.HtmlQuotesConverter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class HtmlQuotesFormatPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psiElement;
        if (node == null) {
            HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = node.getPsi()) != null && psiElement.isValid() && psiElement.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            PsiFile file = psiElement.getContainingFile();
            PsiElement fileContext = file.getContext();
            String contextQuote = fileContext != null ? Character.toString(fileContext.getText().charAt(0)) : null;
            CodeStyleSettings rootSettings = CodeStyle.getSettings((PsiFile)file);
            HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
            CodeStyleSettings.QuoteStyle quoteStyle = htmlSettings.HTML_QUOTE_STYLE;
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None && htmlSettings.HTML_ENFORCE_QUOTES && !StringUtil.equals((CharSequence)quoteStyle.quote, (CharSequence)contextQuote)) {
                PostFormatProcessorHelper postFormatProcessorHelper = new PostFormatProcessorHelper(rootSettings.getCommonSettings((Language)HTMLLanguage.INSTANCE));
                postFormatProcessorHelper.setResultTextRange(range);
                HtmlQuotesConverter converter = new HtmlQuotesConverter(quoteStyle, psiElement, postFormatProcessorHelper);
                Document document = converter.getDocument();
                if (document != null) {
                    DocumentUtil.executeInBulk((Document)document, (Runnable)converter);
                }
                TextRange textRange = postFormatProcessorHelper.getResultTextRange();
                if (textRange == null) {
                    HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(2);
                }
                return textRange;
            }
        }
        TextRange textRange = range;
        if (textRange == null) {
            HtmlQuotesFormatPreprocessor.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/html/HtmlQuotesFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/html/HtmlQuotesFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

