/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.internal.Preconditions;
import com.dynatrace.hash4j.random.PermutationGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.AbstractSimilarityHashPolicy;
import com.dynatrace.hash4j.similarity.ElementHashProvider;
import com.dynatrace.hash4j.similarity.SimilarityHasher;
import java.util.Arrays;
import java.util.Objects;

final class SuperMinHashPolicy_v1
extends AbstractSimilarityHashPolicy {
    private static final double FIRST_ATTEMPT_SUCCESS_PROBABILITY = 0.99;
    private final int[] cycleLimits;

    static int[] initCycleLimits(int numberOfComponents, double firstAttemptSuccessProbability) {
        int[] limits = new int[numberOfComponents];
        limits[0] = 1;
        for (int numberOfEmptyComponents = 0; numberOfEmptyComponents < numberOfComponents; ++numberOfEmptyComponents) {
            limits[numberOfEmptyComponents] = Math.min(Math.max(2, (int)Math.ceil(Math.log(-Math.expm1(Math.log(firstAttemptSuccessProbability) / (double)numberOfComponents)) / Math.log((double)numberOfEmptyComponents / (double)numberOfComponents))), numberOfComponents);
        }
        return limits;
    }

    public SuperMinHashPolicy_v1(int numberOfComponents, int bitsPerComponent, PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        super(numberOfComponents, bitsPerComponent, pseudoRandomGeneratorProvider);
        this.cycleLimits = SuperMinHashPolicy_v1.initCycleLimits(numberOfComponents, 0.99);
    }

    @Override
    public SimilarityHasher createHasher() {
        return new Hasher();
    }

    private class Hasher
    implements SimilarityHasher {
        private final PseudoRandomGenerator pseudoRandomGenerator;
        private final PermutationGenerator permutationGenerator;
        private final long[] hashValuesFractionalPart;
        private final int[] hashValuesIntegralPart;

        private Hasher() {
            this.pseudoRandomGenerator = SuperMinHashPolicy_v1.this.pseudoRandomGeneratorProvider.create();
            this.permutationGenerator = new PermutationGenerator(SuperMinHashPolicy_v1.this.numberOfComponents);
            this.hashValuesFractionalPart = new long[SuperMinHashPolicy_v1.this.numberOfComponents];
            this.hashValuesIntegralPart = new int[SuperMinHashPolicy_v1.this.numberOfComponents];
        }

        @Override
        public byte[] compute(ElementHashProvider elementHashProvider) {
            Objects.requireNonNull(elementHashProvider);
            int numberOfElements = elementHashProvider.getNumberOfElements();
            Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be positive!");
            Arrays.fill(this.hashValuesIntegralPart, Integer.MAX_VALUE);
            int numberOfEmptyComponents = SuperMinHashPolicy_v1.this.numberOfComponents;
            for (int elementIdx = 0; elementIdx < numberOfElements; ++elementIdx) {
                this.pseudoRandomGenerator.reset(elementHashProvider.getElementHash(elementIdx));
                long hashValueFractionalPart = this.pseudoRandomGenerator.nextLong();
                int idx = this.pseudoRandomGenerator.uniformInt(SuperMinHashPolicy_v1.this.numberOfComponents);
                int currentHashValuesIntegralPart = this.hashValuesIntegralPart[idx];
                if (currentHashValuesIntegralPart == Integer.MAX_VALUE) {
                    --numberOfEmptyComponents;
                    this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                    this.hashValuesIntegralPart[idx] = 0;
                    continue;
                }
                if (hashValueFractionalPart >= this.hashValuesFractionalPart[idx]) continue;
                this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
            }
            if (numberOfEmptyComponents > 0) {
                int oldLimit = 1;
                int limit = SuperMinHashPolicy_v1.this.cycleLimits[numberOfEmptyComponents];
                do {
                    for (int elementIdx = 0; elementIdx < numberOfElements; ++elementIdx) {
                        int hashValueIntegralPart;
                        this.pseudoRandomGenerator.reset(elementHashProvider.getElementHash(elementIdx));
                        this.permutationGenerator.reset();
                        for (hashValueIntegralPart = 0; hashValueIntegralPart < oldLimit; ++hashValueIntegralPart) {
                            this.pseudoRandomGenerator.nextLong();
                            this.permutationGenerator.next(this.pseudoRandomGenerator);
                        }
                        for (hashValueIntegralPart = oldLimit; hashValueIntegralPart < limit; ++hashValueIntegralPart) {
                            long hashValueFractionalPart = this.pseudoRandomGenerator.nextLong();
                            int idx = this.permutationGenerator.next(this.pseudoRandomGenerator);
                            int currentHashValuesIntegralPart = this.hashValuesIntegralPart[idx];
                            if (currentHashValuesIntegralPart > hashValueIntegralPart) {
                                if (currentHashValuesIntegralPart == Integer.MAX_VALUE) {
                                    --numberOfEmptyComponents;
                                }
                                this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                                this.hashValuesIntegralPart[idx] = hashValueIntegralPart;
                                continue;
                            }
                            if (currentHashValuesIntegralPart != hashValueIntegralPart || hashValueFractionalPart >= this.hashValuesFractionalPart[idx]) continue;
                            this.hashValuesFractionalPart[idx] = hashValueFractionalPart;
                        }
                    }
                    oldLimit = limit++;
                } while (numberOfEmptyComponents > 0);
            }
            return SuperMinHashPolicy_v1.this.packedArrayHandler.create(i -> this.hashValuesFractionalPart[i], SuperMinHashPolicy_v1.this.numberOfComponents);
        }
    }
}

