/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.terminal.frontend.view.completion.TerminalLookupManagerListenerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/terminal/frontend/view/completion/ShortcutHintTextState;", "Lcom/intellij/codeInsight/lookup/impl/PrefixChangeListener;", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "shortcutText", "", "<init>", "(Lcom/intellij/codeInsight/lookup/Lookup;Ljava/lang/String;)V", "value", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "getValue", "()Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "afterAppend", "", "c", "", "afterTruncate", "calculateHintText", "defaultText", "executeText", "intellij.terminal.frontend"})
final class ShortcutHintTextState
implements PrefixChangeListener {
    @NotNull
    private final Lookup lookup;
    @NotNull
    private final String shortcutText;
    @NotNull
    private final ObservableMutableProperty<String> value;

    public ShortcutHintTextState(@NotNull Lookup lookup, @NotNull String shortcutText) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)shortcutText, (String)"shortcutText");
        this.lookup = lookup;
        this.shortcutText = shortcutText;
        this.value = (ObservableMutableProperty)new AtomicProperty((Object)this.defaultText());
    }

    @NotNull
    public final ObservableMutableProperty<String> getValue() {
        return this.value;
    }

    public void afterAppend(char c) {
        this.value.set((Object)this.calculateHintText());
    }

    public void afterTruncate() {
        this.value.set((Object)this.calculateHintText());
    }

    private final String calculateHintText() {
        LookupElement lookupElement = this.lookup.getCurrentItem();
        if (lookupElement == null) {
            return this.defaultText();
        }
        LookupElement selectedItem = lookupElement;
        String string = this.lookup.itemPattern(selectedItem);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
        String typedPrefix = string;
        String string2 = selectedItem.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        return TerminalLookupManagerListenerKt.canExecuteWithChosenItem(string2, typedPrefix) ? this.executeText() : this.defaultText();
    }

    private final String defaultText() {
        Object[] objectArray = new Object[]{this.shortcutText};
        String string = TerminalBundle.message("terminal.command.completion.insertion.shortcut.hint", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String executeText() {
        Object[] objectArray = new Object[]{this.shortcutText};
        String string = TerminalBundle.message("terminal.command.completion.execution.shortcut.hint", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

