/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.json.highlighting.JsonSyntaxHighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\u0010\u001a\u00020\f2\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J*\u0010\u0015\u001a\u00020\f2\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\"\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00130\u00122\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0019\u001a\u00020\fH\u0002J0\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00072\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00132\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogFormatter;", "Lcom/intellij/diagnostic/logging/DefaultLogFormatter;", "model", "Lcom/intellij/diagnostic/logging/LogFilterModel;", "<init>", "(Lcom/intellij/diagnostic/logging/LogFilterModel;)V", "isMultilineLog", "", "colorMagenta", "Ljava/awt/Color;", "colorGreen", "formatMessage", "", "msg", "updateLogPresentation", "", "formatEventDataToOneLine", "fieldValueList", "", "Lkotlin/Pair;", "isStderr", "formatEventDataToMultiline", "parseEventData", "eventData", "parseFieldValuePair", "fieldValuePair", "paintFieldValue", "fieldValue", "formatedEventData", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "paintInMagenta", "field", "paintInGreen", "value", "getColorForCurrentTheme", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "defaultColor", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogFormatter.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1869#2,2:148\n1869#2,2:150\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogFormatter.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogFormatter\n*L\n51#1:148,2\n65#1:150,2\n*E\n"})
public final class StatisticsEventLogFormatter
extends DefaultLogFormatter {
    @NotNull
    private final LogFilterModel model;
    private boolean isMultilineLog;
    private Color colorMagenta;
    private Color colorGreen;

    public StatisticsEventLogFormatter(@NotNull LogFilterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
    }

    @Nullable
    public String formatMessage(@Nullable String msg) {
        if (msg == null) {
            return null;
        }
        LogFilterModel.MyProcessingResult myProcessingResult = this.model.processLine(msg);
        Intrinsics.checkNotNullExpressionValue((Object)myProcessingResult, (String)"processLine(...)");
        LogFilterModel.MyProcessingResult processingResult = myProcessingResult;
        boolean isStderr = Intrinsics.areEqual((Object)processingResult.getKey(), (Object)ProcessOutputType.STDERR);
        TextAttributesKey textAttributesKey = JsonSyntaxHighlighterFactory.JSON_PROPERTY_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"JSON_PROPERTY_KEY");
        Color color = JBColor.MAGENTA;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"MAGENTA");
        this.colorMagenta = this.getColorForCurrentTheme(textAttributesKey, color);
        TextAttributesKey textAttributesKey2 = JsonSyntaxHighlighterFactory.JSON_STRING;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"JSON_STRING");
        JBColor jBColor = JBColor.GREEN;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GREEN");
        this.colorGreen = this.getColorForCurrentTheme(textAttributesKey2, (Color)jBColor);
        int eventDataOffset = StringsKt.indexOf$default((CharSequence)msg, (char)'{', (int)0, (boolean)false, (int)6, null);
        String string = msg.substring(eventDataOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        List<Pair<String, String>> fieldValueList = this.parseEventData(string);
        String formatedEventData = this.isMultilineLog ? this.formatEventDataToMultiline(fieldValueList, isStderr) : this.formatEventDataToOneLine(fieldValueList, isStderr);
        return ((Object)StringsKt.trim((CharSequence)StringsKt.take((String)msg, (int)eventDataOffset))).toString() + formatedEventData;
    }

    public final void updateLogPresentation(boolean isMultilineLog) {
        this.isMultilineLog = isMultilineLog;
    }

    private final String formatEventDataToOneLine(List<Pair<String, String>> fieldValueList, boolean isStderr) {
        StringBuilder formatedEventData = new StringBuilder();
        formatedEventData.append(" {");
        boolean isFirstPair = false;
        isFirstPair = true;
        Iterable $this$forEach$iv = fieldValueList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!isFirstPair) {
                formatedEventData.append(", ");
            }
            this.paintFieldValue(isStderr, (Pair<String, String>)it, formatedEventData);
            isFirstPair = false;
        }
        formatedEventData.append("}");
        String string = formatedEventData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String formatEventDataToMultiline(List<Pair<String, String>> fieldValueList, boolean isStderr) {
        StringBuilder formatedEventData = new StringBuilder();
        formatedEventData.append("\n{");
        if (!fieldValueList.isEmpty()) {
            formatedEventData.append("\n\t");
        }
        boolean isFirstPair = false;
        isFirstPair = true;
        Iterable $this$forEach$iv = fieldValueList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!isFirstPair) {
                formatedEventData.append(",\n\t");
            }
            this.paintFieldValue(isStderr, (Pair<String, String>)it, formatedEventData);
            isFirstPair = false;
        }
        formatedEventData.append("\n}");
        String string = formatedEventData.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final List<Pair<String, String>> parseEventData(String eventData) {
        List fieldValueList = new ArrayList();
        JsonParser jsonParser = new JsonFactory().createParser(eventData);
        Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"createParser(...)");
        JsonParser parser = jsonParser;
        int startEventDataOffset = 0;
        int endEventDataOffset = 0;
        boolean isFieldValueInProgress = false;
        int bracketsCount = 0;
        block5: while (parser.nextToken() != null) {
            JsonToken token;
            JsonToken jsonToken = token = parser.currentToken();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    if (!isFieldValueInProgress) continue block5;
                    ++bracketsCount;
                    continue block5;
                }
                case 2: {
                    Pair<String, String> fieldValuePair;
                    if (bracketsCount > 0) {
                        --bracketsCount;
                        continue block5;
                    }
                    if (startEventDataOffset != 0) {
                        endEventDataOffset = (int)parser.currentTokenLocation().getCharOffset();
                        String string = eventData.substring(startEventDataOffset, endEventDataOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        fieldValuePair = this.parseFieldValuePair(string);
                        fieldValueList.add(fieldValuePair);
                    }
                    isFieldValueInProgress = false;
                    continue block5;
                }
                case 3: {
                    Pair<String, String> fieldValuePair;
                    isFieldValueInProgress = true;
                    if (bracketsCount > 0) continue block5;
                    if (startEventDataOffset != 0) {
                        endEventDataOffset = (int)parser.currentTokenLocation().getCharOffset();
                        String string = eventData.substring(startEventDataOffset, endEventDataOffset - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        fieldValuePair = this.parseFieldValuePair(((Object)StringsKt.trim((CharSequence)string)).toString());
                        fieldValueList.add(fieldValuePair);
                    }
                    startEventDataOffset = (int)parser.currentTokenLocation().getCharOffset();
                    continue block5;
                }
            }
        }
        return fieldValueList;
    }

    private final Pair<String, String> parseFieldValuePair(String fieldValuePair) {
        int valueOffset = StringsKt.indexOf$default((CharSequence)fieldValuePair, (char)':', (int)0, (boolean)false, (int)6, null);
        String field = StringsKt.take((String)fieldValuePair, (int)valueOffset);
        String string = fieldValuePair.substring(valueOffset + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray = new char[]{','};
        String value = StringsKt.trimEnd((String)string, (char[])cArray);
        return new Pair((Object)field, (Object)value);
    }

    private final void paintFieldValue(boolean isStderr, Pair<String, String> fieldValue, StringBuilder formatedEventData) {
        String formatedField = isStderr ? (String)fieldValue.getFirst() : this.paintInMagenta((String)fieldValue.getFirst());
        formatedEventData.append(formatedField);
        formatedEventData.append(":");
        String formatedValue = isStderr ? (String)fieldValue.getSecond() : this.paintInGreen((String)fieldValue.getSecond());
        formatedEventData.append(formatedValue);
    }

    private final String paintInMagenta(String field) {
        Color color = this.colorMagenta;
        if (color == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorMagenta");
            color = null;
        }
        int n = color.getRed();
        Color color2 = this.colorMagenta;
        if (color2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorMagenta");
            color2 = null;
        }
        int n2 = color2.getGreen();
        Color color3 = this.colorMagenta;
        if (color3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorMagenta");
            color3 = null;
        }
        return "\u001b[38;2;" + n + ";" + n2 + ";" + color3.getBlue() + "m" + field + "\u001b[0m";
    }

    private final String paintInGreen(String value) {
        Color color = this.colorGreen;
        if (color == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorGreen");
            color = null;
        }
        int n = color.getRed();
        Color color2 = this.colorGreen;
        if (color2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorGreen");
            color2 = null;
        }
        int n2 = color2.getGreen();
        Color color3 = this.colorGreen;
        if (color3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"colorGreen");
            color3 = null;
        }
        return "\u001b[38;2;" + n + ";" + n2 + ";" + color3.getBlue() + "m" + value + "\u001b[0m";
    }

    private final Color getColorForCurrentTheme(TextAttributesKey textAttributesKey, Color defaultColor) {
        Color color;
        TextAttributes attribute;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme colorScheme = editorColorsScheme;
        TextAttributes textAttributes = attribute = colorScheme.getAttributes(textAttributesKey);
        if (textAttributes != null) {
            Color color2 = textAttributes.getForegroundColor();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getForegroundColor(...)");
        } else {
            color = defaultColor;
        }
        return color;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.START_OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.END_OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.FIELD_NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

