# Sus::Fixtures::Console

Provides a convenient fixture for capturing or ignoring [console](https://github.com/socketry/console) logging.

[![Development Status](https://github.com/socketry/sus-fixtures-console/workflows/Test/badge.svg)](https://github.com/socketry/sus-fixtures-console/actions?workflow=Test)

## Installation

``` bash
$ bundle add sus-fixtures-console
```

## Usage

Please see the [project documentation](https://socketry.github.io/sus-fixtures-console/) for more details.

  - [Getting Started](https://socketry.github.io/sus-fixtures-console/guides/getting-started/index) - This guide explains how to use the `Sus::Fixtures::Console` gem to redirect console logging output during tests.

## Releases

Please see the [project releases](https://socketry.github.io/sus-fixtures-console/releases/index) for all releases.

### v0.5.0

  - Prefer modules over `Sus::Shared` contexts for better integration.
      - Use `include Sus::Fixtures::Console::NullLogger` instead of `include_context Sus::Fixtures::Console::NullLogger`.

### v0.4.0

  - Add agent context.

### v0.3.1

  - Modernize gem structure and dependencies.

### v0.3.0

    - Add `expect_console` helper method for more fluent test assertions.
    - Add `have_logged` predicate for checking logged messages with specific fields.

### v0.2.0

  - Avoid using nested fiber to prevent potential issues with fiber-based concurrency.

### v0.1.0

    - Add `Sus::Fixtures::Console::CapturedLogger` for capturing console output during tests.
    - Add `Sus::Fixtures::Console::NullLogger` for suppressing console output during tests.

## Contributing

We welcome contributions to this project.

1.  Fork it.
2.  Create your feature branch (`git checkout -b my-new-feature`).
3.  Commit your changes (`git commit -am 'Add some feature'`).
4.  Push to the branch (`git push origin my-new-feature`).
5.  Create new Pull Request.

### Developer Certificate of Origin

In order to protect users of this project, we require all contributors to comply with the [Developer Certificate of Origin](https://developercertificate.org/). This ensures that all contributions are properly licensed and attributed.

### Community Guidelines

This project is best served by a collaborative and respectful environment. Treat each other professionally, respect differing viewpoints, and engage constructively. Harassment, discrimination, or harmful behavior is not tolerated. Communicate clearly, listen actively, and support one another. If any issues arise, please inform the project maintainers.
