/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.Functions;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Element;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.NodeIterator;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.CombiningEvaluator;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.Evaluator;

abstract class StructuralEvaluator
extends Evaluator {
    final Evaluator evaluator;
    final ThreadLocal<IdentityHashMap<Element, IdentityHashMap<Element, Boolean>>> threadMemo = ThreadLocal.withInitial(IdentityHashMap::new);

    /*
     * WARNING - void declaration
     */
    public StructuralEvaluator(Evaluator evaluator) {
        void var1_1;
        this.evaluator = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    boolean memoMatches(Element root, Element element) {
        void var1_1;
        void var2_2;
        Map map = this.threadMemo.get();
        map = map.computeIfAbsent(root, Functions.identityMapFunction());
        return map.computeIfAbsent(var2_2, arg_0 -> this.lambda$memoMatches$0((Element)var1_1, arg_0));
    }

    @Override
    protected void reset() {
        this.threadMemo.get().clear();
        super.reset();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Boolean lambda$memoMatches$0(Element root, Element key) {
        void var2_2;
        void var1_1;
        return this.evaluator.matches((Element)var1_1, (Element)var2_2);
    }

    static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        /*
         * WARNING - void declaration
         */
        public ImmediatePreviousSibling(Evaluator evaluator) {
            super((Evaluator)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Element root, Element element) {
            void var2_2;
            void var1_1;
            if (root == element) {
                return false;
            }
            Element prev = element.previousElementSibling();
            return prev != null && this.memoMatches((Element)var1_1, (Element)var2_2);
        }

        @Override
        protected int cost() {
            return 2 + this.evaluator.cost();
        }

        public String toString() {
            return String.format("%s + ", this.evaluator);
        }
    }

    static class PreviousSibling
    extends StructuralEvaluator {
        /*
         * WARNING - void declaration
         */
        public PreviousSibling(Evaluator evaluator) {
            super((Evaluator)var1_1);
            void var1_1;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            for (Element sib = element.firstElementSibling(); sib != null && sib != element; sib = sib.nextElementSibling()) {
                if (!this.memoMatches(root, sib)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int cost() {
            return 3 * this.evaluator.cost();
        }

        public String toString() {
            return String.format("%s ~ ", this.evaluator);
        }
    }

    static class ImmediateParentRun
    extends Evaluator {
        final ArrayList<Evaluator> evaluators = new ArrayList();
        int cost = 2;

        /*
         * WARNING - void declaration
         */
        public ImmediateParentRun(Evaluator evaluator) {
            void var1_1;
            this.evaluators.add(evaluator);
            this.cost += var1_1.cost();
        }

        /*
         * WARNING - void declaration
         */
        void add(Evaluator evaluator) {
            void var1_1;
            this.evaluators.add(evaluator);
            this.cost += var1_1.cost();
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (element == root) {
                return false;
            }
            for (int i = this.evaluators.size() - 1; i >= 0; --i) {
                if (element == null) {
                    return false;
                }
                Evaluator evaluator = this.evaluators.get(i);
                if (!evaluator.matches(root, element)) {
                    return false;
                }
                element = element.parent();
            }
            return true;
        }

        @Override
        protected int cost() {
            return this.cost;
        }

        public String toString() {
            return StringUtil.join(this.evaluators, " > ");
        }
    }

    static class Parent
    extends StructuralEvaluator {
        /*
         * WARNING - void declaration
         */
        public Parent(Evaluator evaluator) {
            super((Evaluator)var1_1);
            void var1_1;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            for (Element parent = element.parent(); parent != null; parent = parent.parent()) {
                if (this.memoMatches(root, parent)) {
                    return true;
                }
                if (parent == root) break;
            }
            return false;
        }

        @Override
        protected int cost() {
            return 2 * this.evaluator.cost();
        }

        public String toString() {
            return String.format("%s ", this.evaluator);
        }
    }

    static class Not
    extends StructuralEvaluator {
        /*
         * WARNING - void declaration
         */
        public Not(Evaluator evaluator) {
            super((Evaluator)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Element root, Element element) {
            void var2_2;
            void var1_1;
            return !this.memoMatches((Element)var1_1, (Element)var2_2);
        }

        @Override
        protected int cost() {
            return 2 + this.evaluator.cost();
        }

        public String toString() {
            return String.format(":not(%s)", this.evaluator);
        }
    }

    static class Is
    extends StructuralEvaluator {
        /*
         * WARNING - void declaration
         */
        public Is(Evaluator evaluator) {
            super((Evaluator)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Element root, Element element) {
            void var2_2;
            void var1_1;
            return this.evaluator.matches((Element)var1_1, (Element)var2_2);
        }

        @Override
        protected int cost() {
            return 2 + this.evaluator.cost();
        }

        public String toString() {
            return String.format(":is(%s)", this.evaluator);
        }
    }

    static class Has
    extends StructuralEvaluator {
        static final ThreadLocal<NodeIterator<Element>> ThreadElementIter = ThreadLocal.withInitial(() -> new NodeIterator<Element>(new Element("html"), Element.class));
        private final boolean checkSiblings;

        /*
         * WARNING - void declaration
         */
        public Has(Evaluator evaluator) {
            super(evaluator);
            void var1_1;
            this.checkSiblings = Has.evalWantsSiblings((Evaluator)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Element root, Element element) {
            if (this.checkSiblings) {
                for (Element sib = element.firstElementSibling(); sib != null; sib = sib.nextElementSibling()) {
                    if (sib == element || !this.evaluator.matches(element, sib)) continue;
                    return true;
                }
            } else {
                NodeIterator<Element> it = ThreadElementIter.get();
                it.restart(element);
                while (it.hasNext()) {
                    void var3_3;
                    Element el = (Element)it.next();
                    if (el == element || !this.evaluator.matches(element, (Element)var3_3)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static boolean evalWantsSiblings(Evaluator eval) {
            if (eval instanceof CombiningEvaluator) {
                CombiningEvaluator combiningEvaluator;
                combiningEvaluator = combiningEvaluator;
                for (Evaluator innerEval : combiningEvaluator.evaluators) {
                    void var1_1;
                    if (!(innerEval instanceof PreviousSibling) && !(var1_1 instanceof ImmediatePreviousSibling)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected int cost() {
            return 10 * this.evaluator.cost();
        }

        public String toString() {
            return String.format(":has(%s)", this.evaluator);
        }
    }

    static class Root
    extends Evaluator {
        Root() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Element root, Element element) {
            void var2_2;
            return root == var2_2;
        }

        @Override
        protected int cost() {
            return 1;
        }

        public String toString() {
            return "";
        }
    }
}

