export declare enum StatusCategory {
    GENERIC = 0,
    MAC = 2,
    NWK = 3,
    APS = 4,
    ZDO = 5,
    CBKE = 6
}
export declare enum StatusCodeGeneric {
    OK = 0,
    ERROR = 1,
    BLOCKED = 2,
    EXIT = 3,
    BUSY = 4,
    EOF = 5,
    OUT_OF_RANGE = 6,
    EMPTY = 7,
    CANCELLED = 8,
    INVALID_PARAMETER_1 = 10,
    INVALID_PARAMETER_2 = 11,
    INVALID_PARAMETER_3 = 12,
    INVALID_PARAMETER_4 = 13,
    INVALID_PARAMETER_5 = 14,
    INVALID_PARAMETER_6 = 15,
    INVALID_PARAMETER_7 = 16,
    INVALID_PARAMETER_8 = 17,
    INVALID_PARAMETER_9 = 18,
    INVALID_PARAMETER_10 = 19,
    INVALID_PARAMETER_11_OR_MORE = 20,
    PENDING = 21,
    NO_MEMORY = 22,
    INVALID_PARAMETER = 23,
    OPERATION_FAILED = 24,
    BUFFER_TOO_SMALL = 25,
    END_OF_LIST = 26,
    ALREADY_EXISTS = 27,
    NOT_FOUND = 28,
    OVERFLOW = 29,
    TIMEOUT = 30,
    NOT_IMPLEMENTED = 31,
    NO_RESOURCES = 32,
    UNINITIALIZED = 33,
    NO_SERVER = 34,
    INVALID_STATE = 35,
    CONNECTION_FAILED = 37,
    CONNECTION_LOST = 38,
    UNAUTHORIZED = 40,
    CONFLICT = 41,
    INVALID_FORMAT = 42,
    NO_MATCH = 43,
    PROTOCOL_ERROR = 44,
    VERSION = 45,
    MALFORMED_ADDRESS = 46,
    COULD_NOT_READ_FILE = 47,
    FILE_NOT_FOUND = 48,
    DIRECTORY_NOT_FOUND = 49,
    CONVERSION_ERROR = 50,
    INCOMPATIBLE_TYPES = 51,
    FILE_CORRUPTED = 56,
    PAGE_NOT_FOUND = 57,
    ILLEGAL_REQUEST = 62,
    INVALID_GROUP = 64,
    TABLE_FULL = 65,
    IGNORE = 69,
    AGAIN = 70,
    DEVICE_NOT_FOUND = 71,
    OBSOLETE = 72
}
export declare enum StatusCodeAPS {
    SUCCESS = 0,
    ASDU_TOO_LONG = 160,
    DEFRAG_DEFERRED = 161,
    DEFRAG_UNSUPPORTED = 162,
    ILLEGAL_REQUEST = 163,
    INVALID_BINDING = 164,
    INVALID_GROUP = 165,
    INVALID_PARAMETER = 166,
    NO_ACK = 167,
    NO_BOUND_DEVICE = 168,
    NO_SHORT_ADDRESS = 169,
    NOT_SUPPORTED = 170,
    SECURED_LINK_KEY = 171,
    SECURED_NWK_KEY = 172,
    SECURITY_FAIL = 173,
    TABLE_FULL = 174,
    UNSECURED = 175,
    UNSUPPORTED_ATTRIBUTE = 176
}
export declare enum StatusCodeCBKE {
    UNKNOWN_ISSUER = 1,
    BAD_KEY_CONFIRM = 2,
    BAD_MESSAGE = 3,
    NO_RESOURCES = 4,
    UNSUPPORTED_SUITE = 5,
    INVALID_CERTIFICATE = 6,
    NO_KE_EP = 7
}
/**
 * Enum of the network state
 */
export declare enum NetworkState {
    OFFLINE = 0 /*!< The network is offline */,
    JOINING = 1 /*!< Joinging the network */,
    CONNECTED = 2 /*!< Conneted with the network */,
    LEAVING = 3 /*!< Leaving the network */,
    CONFIRM = 4 /*!< Confirm the APS */,
    INDICATION = 5 /*!< Indication the APS */
}
/**
 * Enum of the network security mode
 */
export declare enum EspNCPSecur {
    ESP_NCP_NO_SECURITY = 0 /*!< The network is no security mode */,
    ESP_NCP_PRECONFIGURED_NETWORK_KEY = 1 /*!< Pre-configured the network key */,
    ESP_NCP_NETWORK_KEY_FROM_TC = 2,
    ESP_NCP_ONLY_TCLK = 3
}
export declare enum DeviceType {
    COORDINATOR = 0,
    ROUTER = 1,
    ED = 2,
    NONE = 3
}
export declare enum CommandId {
    GET_MODULE_VERSION = 1,
    NCP_RESET = 2,
    GET_ZIGBEE_ROLE = 4,
    SET_ZIGBEE_ROLE = 5,
    GET_ZIGBEE_CHANNEL_MASK = 6,
    SET_ZIGBEE_CHANNEL_MASK = 7,
    GET_ZIGBEE_CHANNEL = 8,
    GET_PAN_ID = 9,
    SET_PAN_ID = 10,
    GET_LOCAL_IEEE_ADDR = 11,
    SET_LOCAL_IEEE_ADDR = 12,
    GET_TX_POWER = 16,
    SET_TX_POWER = 17,
    GET_RX_ON_WHEN_IDLE = 18,
    SET_RX_ON_WHEN_IDLE = 19,
    GET_JOINED = 20,
    GET_AUTHENTICATED = 21,
    GET_ED_TIMEOUT = 22,
    SET_ED_TIMEOUT = 23,
    SET_NWK_KEY = 27,
    GET_NWK_KEYS = 30,
    GET_APS_KEY_BY_IEEE = 31,
    GET_PARENT_ADDRESS = 34,
    GET_EXTENDED_PAN_ID = 35,
    GET_COORDINATOR_VERSION = 36,
    GET_SHORT_ADDRESS = 37,
    GET_TRUST_CENTER_ADDRESS = 38,
    NCP_RESET_IND = 43,
    NVRAM_WRITE = 46,
    NVRAM_READ = 47,
    NVRAM_ERASE = 48,
    NVRAM_CLEAR = 49,
    SET_TC_POLICY = 50,
    SET_EXTENDED_PAN_ID = 51,
    SET_MAX_CHILDREN = 52,
    GET_MAX_CHILDREN = 53,
    AF_SET_SIMPLE_DESC = 257,
    AF_DEL_SIMPLE_DESC = 258,
    AF_SET_NODE_DESC = 259,
    AF_SET_POWER_DESC = 260,
    ZDO_NWK_ADDR_REQ = 513,
    ZDO_IEEE_ADDR_REQ = 514,
    ZDO_POWER_DESC_REQ = 515,
    ZDO_NODE_DESC_REQ = 516,
    ZDO_SIMPLE_DESC_REQ = 517,
    ZDO_ACTIVE_EP_REQ = 518,
    ZDO_MATCH_DESC_REQ = 519,
    ZDO_BIND_REQ = 520,
    ZDO_UNBIND_REQ = 521,
    ZDO_MGMT_LEAVE_REQ = 522,
    ZDO_PERMIT_JOINING_REQ = 523,
    ZDO_DEV_ANNCE_IND = 524,
    ZDO_REJOIN = 525,
    ZDO_SYSTEM_SRV_DISCOVERY_REQ = 526,
    ZDO_MGMT_BIND_REQ = 527,
    ZDO_MGMT_LQI_REQ = 528,
    ZDO_MGMT_NWK_UPDATE_REQ = 529,
    ZDO_GET_STATS = 531,
    ZDO_DEV_AUTHORIZED_IND = 532,
    ZDO_DEV_UPDATE_IND = 533,
    ZDO_SET_NODE_DESC_MANUF_CODE = 534,
    APSDE_DATA_REQ = 769,
    APSME_BIND = 770,
    APSME_UNBIND = 771,
    APSME_ADD_GROUP = 772,
    APSME_RM_GROUP = 773,
    APSDE_DATA_IND = 774,
    APSME_RM_ALL_GROUPS = 775,
    APS_CHECK_BINDING = 776,
    APS_GET_GROUP_TABLE = 777,
    APSME_UNBIND_ALL = 778,
    NWK_FORMATION = 1025,
    NWK_DISCOVERY = 1026,
    NWK_NLME_JOIN = 1027,
    NWK_PERMIT_JOINING = 1028,
    NWK_GET_IEEE_BY_SHORT = 1029,
    NWK_GET_SHORT_BY_IEEE = 1030,
    NWK_GET_NEIGHBOR_BY_IEEE = 1031,
    NWK_REJOINED_IND = 1033,
    NWK_REJOIN_FAILED_IND = 1034,
    NWK_LEAVE_IND = 1035,
    PIM_SET_FAST_POLL_INTERVAL = 1038,
    PIM_SET_LONG_POLL_INTERVAL = 1039,
    PIM_START_FAST_POLL = 1040,
    PIM_START_LONG_POLL = 1041,
    PIM_START_POLL = 1042,
    PIM_STOP_FAST_POLL = 1044,
    PIM_STOP_POLL = 1045,
    PIM_ENABLE_TURBO_POLL = 1046,
    PIM_DISABLE_TURBO_POLL = 1047,
    NWK_PAN_ID_CONFLICT_RESOLVE = 1050,
    NWK_PAN_ID_CONFLICT_IND = 1051,
    NWK_ADDRESS_UPDATE_IND = 1052,
    NWK_START_WITHOUT_FORMATION = 1053,
    NWK_NLME_ROUTER_START = 1054,
    PARENT_LOST_IND = 1056,
    PIM_START_TURBO_POLL_PACKETS = 1060,
    PIM_START_TURBO_POLL_CONTINUOUS = 1061,
    PIM_TURBO_POLL_CONTINUOUS_LEAVE = 1062,
    PIM_TURBO_POLL_PACKETS_LEAVE = 1063,
    PIM_PERMIT_TURBO_POLL = 1064,
    PIM_SET_FAST_POLL_TIMEOUT = 1065,
    PIM_GET_LONG_POLL_INTERVAL = 1066,
    PIM_GET_IN_FAST_POLL_FLAG = 1067,
    SET_KEEPALIVE_MOVE = 1068,
    START_CONCENTRATOR_MODE = 1069,
    STOP_CONCENTRATOR_MODE = 1070,
    NWK_ENABLE_PAN_ID_CONFLICT_RESOLUTION = 1071,
    NWK_ENABLE_AUTO_PAN_ID_CONFLICT_RESOLUTION = 1072,
    PIM_TURBO_POLL_CANCEL_PACKET = 1073,
    SECUR_SET_LOCAL_IC = 1281,
    SECUR_ADD_IC = 1282,
    SECUR_DEL_IC = 1283,
    SECUR_GET_LOCAL_IC = 1293,
    SECUR_TCLK_IND = 1294,
    SECUR_TCLK_EXCHANGE_FAILED_IND = 1295,
    SECUR_NWK_INITIATE_KEY_SWITCH_PROCEDURE = 1303,
    SECUR_GET_IC_LIST = 1304,
    SECUR_GET_IC_BY_IDX = 1305,
    SECUR_REMOVE_ALL_IC = 1306,
    UNKNOWN_1 = 2562
}
export declare enum ResetOptions {
    NoOptions = 0,
    EraseNVRAM = 1,
    FactoryReset = 2,
    LockReadingKeys = 3
}
export declare enum ResetSource {
    RESET_SRC_POWER_ON = 0,
    RESET_SRC_SW_RESET = 1,
    RESET_SRC_RESET_PIN = 2,
    RESET_SRC_BROWN_OUT = 3,
    RESET_SRC_CLOCK_LOSS = 4,
    RESET_SRC_OTHER = 5
}
export declare enum PolicyType {
    LINK_KEY_REQUIRED = 0,
    IC_REQUIRED = 1,
    TC_REJOIN_ENABLED = 2,
    IGNORE_TC_REJOIN = 3,
    APS_INSECURE_JOIN = 4,
    DISABLE_NWK_MGMT_CHANNEL_UPDATE = 5
}
export declare enum BuffaloZBOSSDataType {
    LIST_TYPED = 3000,
    EXTENDED_PAN_ID = 3001
}
export declare enum DeviceAuthorizedType {
    LEGACY = 0,
    R21_TCLK = 1,
    SE_CBKE = 2
}
export declare enum DeviceAuthorizedLegacyStatus {
    SUCCESS = 0,
    FAILED = 1
}
export declare enum DeviceAuthorizedR21TCLKStatus {
    SUCCESS = 0,
    TIMEOUT = 1,
    FAILED = 2
}
export declare enum DeviceAuthorizedSECBKEStatus {
    SUCCESS = 0
}
export declare enum DeviceUpdateStatus {
    SECURED_REJOIN = 0,
    UNSECURED_JOIN = 1,
    LEFT = 2,
    TC_REJOIN = 3
}
export declare enum DeviceUpdateTCAction {
    AUTHORIZE = 0,
    DENY = 1,
    IGNORE = 2
}
//# sourceMappingURL=enums.d.ts.map